package com.ejianc.foundation.front.business.ide.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * @author cdrcool
 */
@RequestMapping("metadataReader")
@RestController
public class MetadataReaderController {
    @Autowired
    private MetadataReaderService service;

    /**
     * 获取实体元数据
     *
     * @param billTypeId 单据类型id
     * @return 实体元数据
     */
    @RequestMapping(value = "getEntityMeta", method = RequestMethod.GET)
    public JsonBackData getEntityMeta(String billTypeId) {
        JsonBackData backData = new JsonBackData();
        backData.setSuccess(true);
        backData.setBackMsg("获取实体元数据成功");

        try {
            backData.setBackData(service.getMetadata(billTypeId));
        } catch (Exception e) {
            backData.setSuccess(false);
            backData.setBackMsg("获取实体元数据异常："  + e.getMessage());
        }

        return backData;
    }
}
