package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeUiFolder;

@Mapper
public interface IdeUiFolderRepo {

    /**
     * 查找库下面的文件夹列表
     *
     * @param libraryId 库id
     * @return 文件夹列表
     */
    List<IdeUiFolder> findByLibraryIdAndIsRootTrue(@Param("libraryId") String libraryId);

    /**
     * 查找子文件夹列表
     *
     * @param parentId 父id
     * @return 子文件夹列表
     */
    List<IdeUiFolder> findByParentId(@Param("parentId") String parentId);

	IdeUiFolder findOne(@Param("id") String id);
	 
	void save(IdeUiFolder entity);

	void delete(@Param("parentId") String parentId);

	void update(IdeUiFolder entity);
}
