/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.service.SqlExportService;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/sqlExport"})
public class IdeSqlExportController {
    @Autowired
    private SqlExportService sqlExportService;
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeSqlExportController.class);

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody(required=false) Map<String, Object> paras) {
        try {
            List appCodes = (List)paras.get("appCodes");
            List teamCodes = (List)paras.get("teamCodes");
            List<String> result = this.sqlExportService.exportSql(req, appCodes, teamCodes);
            StringBuffer fileName = new StringBuffer();
            String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            fileName.append(date);
            fileName.append(".sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", result).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

