/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.service.IdeTeamService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ide/team"})
public class IdeTeamController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeTeamService teamService;

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeTeam team) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.teamService.save(team));
            backData.setBackMsg("\u4fdd\u5b58\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u4fdd\u5b58\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u4fdd\u5b58\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"updateServerUrls"}, method={RequestMethod.POST})
    public JsonBackData updateServerUrls(String id, String serverUrls) {
        JsonBackData backData = new JsonBackData();
        try {
            if (StringUtils.isEmpty(serverUrls)) {
                throw new BusinessException("\u672a\u9009\u62e9\u53ef\u53d1\u5e03\u7684\u73af\u5883\uff01");
            }
            backData.setBackData(this.teamService.updateServerUrls(id, serverUrls));
            backData.setBackMsg("\u66f4\u65b0\u56e2\u961f\u670d\u52a1\u5730\u5740\u914d\u7f6e\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u66f4\u65b0\u56e2\u961f\u670d\u52a1\u5730\u5740\u914d\u7f6e\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u56e2\u961f\u670d\u52a1\u5730\u5740\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u66f4\u65b0\u56e2\u961f\u670d\u52a1\u5730\u5740\u914d\u7f6e\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData get(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.teamService.findById(id));
            backData.setBackMsg("\u83b7\u53d6\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u83b7\u53d6\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u83b7\u53d6\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.deleteById(id);
            backData.setBackMsg("\u5220\u9664\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u5220\u9664\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u5220\u9664\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"page"}, method={RequestMethod.GET})
    public JsonBackData queryTeams(String key, String createId, @RequestParam(value="prodType", defaultValue="0") int prodType, @RequestParam(value="pageNumber", defaultValue="0") int pageNumber, @RequestParam(value="pageSize", defaultValue="10") int pageSize) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.teamService.queryForPage(key, createId, prodType, (Pageable)new PageRequest(pageNumber, pageSize, new Sort(Arrays.asList(new Sort.Order(Sort.Direction.DESC, "roleType"), new Sort.Order(Sort.Direction.DESC, "code"))))));
            backData.setBackMsg("\u5206\u9875\u67e5\u8be2\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u9875\u67e5\u8be2\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u5206\u9875\u67e5\u8be2\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"teams/{createId}"}, method={RequestMethod.GET})
    public JsonBackData queryUserTeams(@PathVariable(value="createId") String createId, @RequestParam(value="prodType", defaultValue="0") int prodType) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.teamService.queryUserTeams(createId, prodType));
            backData.setBackMsg("\u67e5\u8be2\u7528\u6237\u5f52\u5c5e\u7684\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u67e5\u8be2\u7528\u6237\u5f52\u5c5e\u7684\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7528\u6237\u5f52\u5c5e\u7684\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u67e5\u8be2\u7528\u6237\u5f52\u5c5e\u7684\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"users/{id}"}, method={RequestMethod.GET})
    public JsonBackData queryTeamUsers(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.teamService.findUsers(id));
            backData.setBackMsg("\u83b7\u53d6\u56e2\u961f\u4e0b\u6240\u6709\u7528\u6237\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u83b7\u53d6\u56e2\u961f\u4e0b\u6240\u6709\u7528\u6237\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u56e2\u961f\u4e0b\u6240\u6709\u7528\u6237\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u83b7\u53d6\u56e2\u961f\u4e0b\u6240\u6709\u7528\u6237\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"applyToJoin"}, method={RequestMethod.POST})
    public JsonBackData applyToJoin(String teamId, String userId) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.applyToJoin(teamId, userId);
            backData.setBackMsg("\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u7533\u8bf7\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"agreeToJoin"}, method={RequestMethod.POST})
    public JsonBackData agreeToJoin(String teamId, String userId) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.agreeToJoin(teamId, userId);
            backData.setBackMsg("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"refuseToJoin"}, method={RequestMethod.POST})
    public JsonBackData refuseToJoin(String teamId, String userId) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.refuseToJoin(teamId, userId);
            backData.setBackMsg("\u62d2\u7edd\u7528\u6237\u52a0\u5165\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u62d2\u7edd\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u62d2\u7edd\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u62d2\u7edd\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"agreeToJoinByCode"}, method={RequestMethod.POST})
    public JsonBackData agreeToJoinByCode(String teamId, String code) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.agreeToJoinByCode(teamId, code);
            backData.setBackMsg("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u540c\u610f\u7528\u6237\u52a0\u5165\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"removeUsers"}, method={RequestMethod.POST})
    public JsonBackData removeUsers(String teamId, String[] userIds) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.removeUsers(teamId, userIds);
            backData.setBackMsg("\u4ece\u56e2\u961f\u4e2d\u79fb\u9664\u7528\u6237\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u4ece\u56e2\u961f\u4e2d\u79fb\u9664\u7528\u6237\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4ece\u56e2\u961f\u4e2d\u79fb\u9664\u7528\u6237\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u4ece\u56e2\u961f\u4e2d\u79fb\u9664\u7528\u6237\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"updateTeamCreator"})
    public JsonBackData updateTeamCreator(String teamId, String userId) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.updateTeamCreator(teamId, userId);
            backData.setBackMsg("\u8bbe\u4e3a\u521b\u5efa\u8005\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u8bbe\u4e3a\u521b\u5efa\u8005\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u4e3a\u521b\u5efa\u8005\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u8bbe\u4e3a\u521b\u5efa\u8005\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"setTeamManagers"})
    public JsonBackData setTeamManagers(String teamId, String[] userIds) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.setTeamManagers(teamId, userIds);
            backData.setBackMsg("\u8bbe\u4e3a\u7ba1\u7406\u5458\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u8bbe\u4e3a\u7ba1\u7406\u5458\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u4e3a\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u63d0\u5347\u7528\u6237\u4e3a\u7ba1\u7406\u5458\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"cancelTeamManagers"})
    public JsonBackData cancelTeamManagers(String teamId, String[] userIds) {
        JsonBackData backData = new JsonBackData();
        try {
            this.teamService.cancelTeamManagers(teamId, userIds);
            backData.setBackMsg("\u64a4\u9500\u7528\u6237\u7ba1\u7406\u5458\u89d2\u8272\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u64a4\u9500\u7528\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u64a4\u9500\u7528\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u64a4\u9500\u7528\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25");
        }
        return backData;
    }
}

