/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ide/app"})
public class IdeAppController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeAppController.class);
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeModuleService ideModuleService;

    @Deprecated
    @RequestMapping(value={"findByUser"}, method={RequestMethod.GET})
    public JsonBackData findByUser(@RequestParam String userId, @RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> ideAppBos = this.ideAppService.findByCreateId(userId, clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"findByCode"}, method={RequestMethod.GET})
    public JsonBackData findByCode(@RequestParam String code) {
        JsonBackData backData = new JsonBackData();
        try {
            IdeApp ideApp = this.ideAppService.findByCode(code);
            backData.setBackData(ideApp);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"teamapps"}, method={RequestMethod.GET})
    public JsonBackData findTeamAppsByUser(@RequestParam String userId, @RequestParam(value="prodType", defaultValue="0") int prodType, @RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeTeamBo> ideAppBos = this.ideAppService.findTeamAppsByUser(userId, prodType, clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"publicapps"}, method={RequestMethod.GET})
    public JsonBackData findTeamPublicApps(@RequestParam String userId, @RequestParam(value="prodType", defaultValue="0") int prodType, @RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeTeamBo> ideAppBos = this.ideAppService.findTeamPublicApps(userId, prodType, clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"noteam/{userId}"}, method={RequestMethod.GET})
    public JsonBackData findNoTeamApps(@PathVariable String userId, @RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> ideAppBos = this.ideAppService.findNoTeamApps(userId, clientType);
            backData.setBackData(ideAppBos);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeApp ideApp) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.saveOrUpdate(ideApp);
            backData.setSuccess(true);
            backData.setBackMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.deleteById(id);
            backData.setBackMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"remove/{id}"}, method={RequestMethod.DELETE})
    public JsonBackData remove(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.removeById(id);
            backData.setBackMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"recover/{id}"}, method={RequestMethod.POST})
    public JsonBackData recover(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.recoverById(id);
            backData.setBackMsg("\u6062\u590d\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"pages"}, method={RequestMethod.POST})
    public JsonBackData findAppPages(@RequestBody String[] appIds) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.ideModuleService.findInAppIds(appIds));
            backData.setBackMsg("\u83b7\u53d6\u9875\u9762\u57fa\u7840\u6570\u636e\u6210\u529f");
            backData.setSuccess(true);
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"{appId}/module"}, method={RequestMethod.GET})
    public JsonBackData module(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeModule> result = this.ideModuleService.findByAppId(appId);
            backData.setBackData(result);
        }
        catch (BusinessException e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
        }
        return backData;
    }

    @RequestMapping(value={"{appId}/moduleIsDelete"}, method={RequestMethod.GET})
    public JsonBackData moduleIsDelete(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeModule> result = this.ideModuleService.findIsDeleteModules(appId);
            backData.setBackData(result);
        }
        catch (BusinessException e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
        }
        return backData;
    }

    @RequestMapping(value={"copy"}, method={RequestMethod.POST})
    public JsonBackData copy(@RequestBody IdeApp ideApp) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.copyApp(ideApp);
            backData.setBackMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
        }
        return backData;
    }

    @RequestMapping(value={"open"}, method={RequestMethod.POST})
    public JsonBackData open(@RequestParam(required=true, value="open", defaultValue="0") int open, @RequestParam String id, @RequestParam String createId) {
        try {
            this.ideAppService.updateOpen(id, open, createId);
            return JsonBackData.toSuccess("\u516c\u5f00\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError("\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestMapping(value={"all"}, method={RequestMethod.GET})
    public JsonBackData allApps(@RequestParam(value="isDelete") boolean isDelete, @RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeApp> result = this.ideAppService.findAllApps(isDelete, clientType);
            backData.setSuccess(true);
            backData.setBackData(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"bindteam"}, method={RequestMethod.POST})
    public JsonBackData bindTeamOfApps(@RequestParam String teamId, @RequestBody String[] appIds, @RequestParam String groupId) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.bindTeamOfApps(teamId, appIds, groupId);
            backData.setBackMsg("\u7ed1\u5b9a\u5e94\u7528\u5176\u6240\u5c5e\u7684\u56e2\u961f\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u7ed1\u5b9a\u5e94\u7528\u5176\u6240\u5c5e\u7684\u56e2\u961f\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u7ed1\u5b9a\u5e94\u7528\u5176\u6240\u5c5e\u7684\u56e2\u961f\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u7ed1\u5b9a\u5e94\u7528\u5176\u6240\u5c5e\u7684\u56e2\u961f\u5931\u8d25");
        }
        return backData;
    }
}

