/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"ide/modulePrivate"})
public class IdeModulePrivateController {
    @Autowired
    private IdeModulePrivateService ideModulePrivateService;

    @ResponseBody
    @RequestMapping(value={"showList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<IdeModulePrivate>> showList(@RequestBody Map<String, Object> query) {
        int pageNumber = (Integer)query.get("pageIndex");
        int pageSize = (Integer)query.get("pageSize");
        String code = (String)query.get("code");
        String orgId = (String)query.get("orgId");
        String appId = (String)query.get("appId");
        String tenantId = (String)query.get("tenantId");
        try {
            IPage<IdeModulePrivate> pageable = this.ideModulePrivateService.findByCode(pageNumber, pageSize, code, orgId, appId, tenantId);
            return CommonResponse.success(pageable);
        }
        catch (BusinessException e) {
            return CommonResponse.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    @ResponseBody
    @RequestMapping(value={"searchPages"}, method={RequestMethod.GET})
    public List<IdeModuleBo> searchList(String searchText, Integer limit) {
        List<IdeModuleBo> backData = new ArrayList<IdeModuleBo>();
        try {
            backData = this.ideModulePrivateService.searchByModuleCodeAndName(searchText, limit);
            for (IdeModuleBo module : backData) {
                module.setData(module.getName());
                module.setName(module.getTeamName() + "->" + module.getAppName() + "->" + module.getName());
            }
        }
        catch (BusinessException e) {
            e.printStackTrace();
        }
        return backData;
    }

    @ResponseBody
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public JsonBackData saveOrUpdate(@RequestBody IdeModulePrivate bo) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideModulePrivateService.saveOrUpdate(bo);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"changeIsDevelopment"}, method={RequestMethod.POST})
    public JsonBackData changeIsDevelopment(@RequestBody IdeModulePrivate bo) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideModulePrivateService.changeIsDevelopment(bo);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        try {
            this.ideModulePrivateService.deleteByIds(ids);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findByCodeAndOrgId"})
    public JsonBackData findByCodeAndOrgId(String appCode, String pageCode, String orgId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideModulePrivateService.findByOrgIdAndCode(pageCode, appCode, orgId));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"saveData"}, method={RequestMethod.POST})
    public JsonBackData saveData(@RequestBody IdeModulePrivate bo) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideModulePrivateService.saveData(bo);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findNodeIdsHasData"})
    public JsonBackData findNodeIdsHasData(String orgId, String tenantId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideModulePrivateService.findNodeIds(orgId, tenantId));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"showModuleByAppId"})
    public JsonBackData showAppByTeamId(@RequestParam String appId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideModulePrivateService.findModule(appId));
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @RequestMapping(value={"backup/{id}"}, method={RequestMethod.GET})
    public void backup(@PathVariable(value="id") String id, String filename, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        String fileName = new String(filename.getBytes("utf-8"), "ISO-8859-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".txt\"");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            String data = this.ideModulePrivateService.findById(id).getData();
            outputStream.write(data.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (BusinessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    @RequestMapping(value={"restore"}, method={RequestMethod.POST})
    public JsonBackData restore(@RequestParam(value="file") CommonsMultipartFile file, String pageId) {
        try {
            boolean valide;
            ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
            String myString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            IdeModulePrivate ideModulePrivate = this.ideModulePrivateService.findById(pageId);
            JSONObject newData = JSONObject.parseObject((String)myString);
            JSONObject oldData = JSONObject.parseObject((String)ideModulePrivate.getData());
            boolean bl = valide = oldData != null && oldData.get((Object)"uitype").equals(newData.get((Object)"uitype"));
            if (valide || oldData == null) {
                ideModulePrivate.setModifyDate(new Date());
                ideModulePrivate.setData(myString);
                this.ideModulePrivateService.updateData(ideModulePrivate);
                return JsonBackData.toSuccess();
            }
            return JsonBackData.toError("\u9875\u9762\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"getrestore"}, method={RequestMethod.POST})
    public JsonBackData getRestore(@RequestParam(value="file") CommonsMultipartFile file, String pageId) {
        try {
            boolean valide;
            ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
            String myString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            IdeModulePrivate ideModulePrivate = this.ideModulePrivateService.findById(pageId);
            JSONObject newData = JSONObject.parseObject((String)myString);
            JSONObject oldData = JSONObject.parseObject((String)ideModulePrivate.getData());
            boolean bl = valide = oldData != null && oldData.get((Object)"uitype").equals(newData.get((Object)"uitype"));
            if (valide || oldData == null) {
                return JsonBackData.toSuccessData(myString);
            }
            return JsonBackData.toError("\u5bfc\u5165\u5931\u8d25\uff1a\u9875\u9762\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @ResponseBody
    @RequestMapping(value={"updateAttach"}, method={RequestMethod.POST})
    public JsonBackData updateAttach(@RequestBody IdeModulePrivate ideModulePrivate) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideModulePrivateService.updateAttach(ideModulePrivate);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"updateAttachVerify"}, method={RequestMethod.POST})
    public JsonBackData updateAttachVerify(@RequestBody Map<String, Object> param) {
        JsonBackData back = new JsonBackData();
        List ids = (List)param.get("ids");
        String modifyId = (String)param.get("modifyId");
        String modifyName = (String)param.get("modifyName");
        try {
            this.ideModulePrivateService.updateAttachVerify(ids, modifyId, modifyName);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"showUnverifyList"}, method={RequestMethod.POST})
    public JsonBackData showUnverifyList(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        int pageNumber = (Integer)query.get("pageNumber");
        int pageSize = (Integer)query.get("pageSize");
        String code = (String)query.get("code");
        String orgId = (String)query.get("orgId");
        String appId = (String)query.get("appId");
        String tenantId = (String)query.get("tenantId");
        String condition = (String)query.get("condition");
        try {
            PageRequest pageable = null;
            pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
            back.setBackData(this.ideModulePrivateService.findUnverifyList(code, orgId, appId, tenantId, (Pageable)pageable, condition));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"showVerifyHistoryList"}, method={RequestMethod.POST})
    public JsonBackData showVerifyHistoryList(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        int pageNumber = (Integer)query.get("pageNumber");
        int pageSize = (Integer)query.get("pageSize");
        String code = (String)query.get("code");
        String orgId = (String)query.get("orgId");
        String appId = (String)query.get("appId");
        String tenantId = (String)query.get("tenantId");
        String condition = (String)query.get("condition");
        try {
            PageRequest pageable = null;
            pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
            back.setBackData(this.ideModulePrivateService.findVerifyHistoryList(code, orgId, appId, tenantId, (Pageable)pageable, condition));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }
}

