/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.service.IdeTeamDatasourceService;
import com.ejianc.foundation.front.util.JsonBackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/ide/teamConfig"})
@Controller
public class IdeTeamDatasourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamDatasourceController.class);
    @Autowired
    private IdeTeamDatasourceService datasourceService;

    @RequestMapping(value={"/updateTeamDatasource/{teamId}"}, method={RequestMethod.POST})
    public JsonBackData updateTeamDatasource(@PathVariable String teamId, String[] datasourceCodes) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.datasourceService.updateTeamDatasource(teamId, datasourceCodes));
            backData.setSuccess(true);
            backData.setBackMsg("\u66f4\u6539\u56e2\u961f\u6570\u636e\u6e90\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u6539\u56e2\u961f\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"{ids}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable(value="ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            this.datasourceService.deleteByIds(ids);
            backData.setBackMsg("\u5220\u9664\u56e2\u961f\u6570\u636e\u6e90\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u56e2\u961f\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u5220\u9664\u56e2\u961f\u6570\u636e\u6e90\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData get(@PathVariable(value="id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.datasourceService.findById(id));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u56e2\u961f\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"findByTeamId/{teamId}"}, method={RequestMethod.GET})
    public JsonBackData findByTeamId(@PathVariable String teamId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.datasourceService.findByTeamId(teamId));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }
}

