/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional(readOnly=true)
@Service
public class IdeModuleGroupServiceImpl
implements IdeModuleGroupService {
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    private IdeModuleGroupRepo moduleGroupRepo;
    @Autowired
    private IdeModuleRepo ideModuleRepo;

    @Override
    @Transactional
    public IdeModuleGroup save(IdeModuleGroup moduleGroup) {
        boolean isAdd = StringUtils.isEmpty((Object)moduleGroup.getId());
        if (isAdd) {
            moduleGroup.setId(IdWorker.getId());
            moduleGroup.setCode(this.ideCommonService.generateModuleGroupCode());
            moduleGroup.setCreateDate(new Date());
            moduleGroup.setCreateId(InvocationInfoProxy.getUserid());
            this.moduleGroupRepo.save(moduleGroup);
        } else {
            IdeModuleGroup _moduleGroup = this.moduleGroupRepo.findOne(moduleGroup.getId());
            _moduleGroup.setName(moduleGroup.getName());
            _moduleGroup.setModifyDate(new Date());
            _moduleGroup.setModifyId(InvocationInfoProxy.getUserid());
            this.moduleGroupRepo.update(_moduleGroup);
        }
        return moduleGroup;
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        IdeModuleGroup moduleGroup = this.moduleGroupRepo.findOne(Long.parseLong(id));
        if (moduleGroup == null) {
            throw new BusinessException("\u8be5\u5e94\u7528\u6a21\u5757\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!");
        }
        this.moduleGroupRepo.logicDel(moduleGroup.getId());
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        Arrays.stream(ids).forEach(this::deleteById);
        String idStr = "";
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            this.ideModuleRepo.updateGroupId(idStr.substring(0, idStr.length() - 1));
        }
    }

    @Override
    public IdeModuleGroup findById(String id) {
        return this.moduleGroupRepo.findOne(Long.parseLong(id));
    }

    @Override
    public List<IdeModuleGroup> findByAppId(String appId) {
        return this.moduleGroupRepo.findByAppId(appId);
    }
}

