/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeOnline;
import com.ejianc.foundation.front.business.ide.entity.IdeRelease;
import com.ejianc.foundation.front.business.ide.entity.IdeReleasePage;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeOnlineRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeReleasePageRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeReleaseRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.IdeReleaseService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional(readOnly=true)
@Service
public class IdeReleaseServiceImpl
implements IdeReleaseService {
    private static final Logger log = LoggerFactory.getLogger(IdeReleaseServiceImpl.class);
    @Autowired
    private IdeModuleService moduleService;
    @Autowired
    private IdeAppService ideAppService;
    @Autowired
    private IdeEnvironmentService ideEnvironmentService;
    @Autowired
    private IdeModuleService ideModuleService;
    @Autowired
    private IdeModuleProService ideModuleProService;
    @Autowired
    private IdeReleaseRepo releaseRepo;
    @Autowired
    private IdeReleasePageRepo releasePageRepo;
    @Autowired
    private IdeOnlineRepo onlineRepo;
    @Autowired
    private IdeTeamRepo ideTeamRepo;
    @Autowired
    private IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;

    @Override
    @Transactional
    public void release(String appId, String version, List<String> pageIds, String releaseGroupId) {
        IdeRelease ideRelease = this.releaseRepo.findByVersion(version, appId);
        if (ideRelease != null) {
            throw new BusinessException("\u8be5\u7248\u672c\u53f7\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u53d1\u7248\uff01");
        }
        Long releaseId = IdWorker.getId();
        IdeRelease release = new IdeRelease();
        release.setId(releaseId);
        release.setVersion(version);
        release.setReleaseTime(new Date());
        release.setAppId(Long.parseLong(appId));
        release.setReleaseGroupId(Long.parseLong(releaseGroupId));
        this.releaseRepo.save(release);
        List<IdeModule> modules = this.moduleService.findByIds(pageIds);
        if (modules != null && modules.size() > 0) {
            for (IdeModule module : modules) {
                IdeReleasePage page = new IdeReleasePage();
                page.setId(IdWorker.getId());
                page.setReleaseId(release.getId());
                page.setReleaseGroupId(Long.parseLong(releaseGroupId));
                page.setPageId(module.getId());
                page.setPageCode(module.getCode());
                page.setPageName(module.getName());
                page.setPageData(module.getData());
                page.setAppId(module.getAppId());
                this.releasePageRepo.save(page);
            }
        }
    }

    @Override
    public List<IdeRelease> findReleases(String appId) {
        return this.releaseRepo.findByAppIdOrderByReleaseTimeDesc(appId);
    }

    @Override
    public List<IdeReleasePage> findReleasePages(String releaseGroupId) {
        return this.releasePageRepo.findByReleaseGroupIdOrderByPageCodeAsc(releaseGroupId);
    }

    @Override
    @Transactional
    public void online(String releaseGroupId, String envUrl) {
        List<IdeRelease> releases = this.releaseRepo.findByGroupId(releaseGroupId);
        List<IdeReleasePage> releasePages = this.releasePageRepo.findByReleaseGroupIdOrderByPageCodeAsc(releaseGroupId);
        if (releases != null && releases.size() > 0) {
            ArrayList<IdeOnline> onlines = new ArrayList<IdeOnline>();
            ArrayList<IdeProductionBo> postDatas = new ArrayList<IdeProductionBo>();
            for (IdeRelease release : releases) {
                IdeApp app = this.ideAppService.findById(String.valueOf(release.getAppId()));
                if (!this.ideEnvironmentService.isInWhiteList(envUrl, String.valueOf(app.getTeamId()))) {
                    throw new BusinessException(String.format("\u672c\u56e2\u961f\u88ab\u9650\u5236\u53d1\u5e03\u5e94\u7528\u5230[%s]\u73af\u5883\uff0c\u53ef\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01", envUrl));
                }
                IdeTeamBo team = new IdeTeamBo(this.ideTeamRepo.findOne(String.valueOf(app.getTeamId())));
                IdeOnline online = new IdeOnline();
                online.setId(IdWorker.getId());
                online.setAppId(app.getId());
                online.setReleaseGroupId(Long.parseLong(releaseGroupId));
                online.setOnlineTime(new Date());
                online.setOnlineEnvUrl(envUrl);
                onlines.add(online);
                this.onlineRepo.save(online);
                IdeProductionBo postData = new IdeProductionBo();
                postData.setIdeApp(new IdeAppBo(app));
                postData.setIdeTeam(team);
                postData.setToName(envUrl);
                postDatas.add(postData);
            }
            List<IdeModule> publishModules = releasePages.stream().map(page -> {
                IdeModule ideModule = this.ideModuleRepo.findById(String.valueOf(page.getPageId()));
                if (ideModule != null) {
                    ideModule.setCode(page.getPageCode());
                    ideModule.setName(page.getPageName());
                    ideModule.setData(page.getPageData());
                }
                return ideModule;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(publishModules = this.ideModuleProService.findDiffLastPublish(publishModules, envUrl))) {
                throw new BusinessException("\u6240\u53d1\u5e03\u9875\u9762\u4e0e\u6700\u65b0\u7248\u672c\u76f8\u540c\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03");
            }
            for (IdeProductionBo postData : postDatas) {
                String result;
                publishModules.stream().filter(module -> postData.getIdeApp().getId().equals(String.valueOf(module.getAppId()))).forEach(module -> postData.getIdeModules().add(new IdeModuleBo((IdeModule)module)));
                String postJson = JSONObject.toJSONString((Object)postData);
                log.info("postJson: {}", (Object)postJson);
                HttpResponse httpresponse = HttpClientUtil.postJSON(envUrl + "/ejc-front-web/ide/production/syncreceive", postJson);
                if (httpresponse == null) {
                    throw new BusinessException("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
                }
                int resCode = httpresponse.getStatusLine().getStatusCode();
                if (resCode != 200) {
                    throw new BusinessException("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + resCode);
                }
                try {
                    result = EntityUtils.toString((HttpEntity)httpresponse.getEntity());
                }
                catch (IOException e) {
                    throw new BusinessException("json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
                }
                JSONObject resultObj = (JSONObject)JSONObject.parse((String)result);
                boolean success = resultObj.getBoolean("success");
                if (success) continue;
                log.error("\u53d1\u5e03\u5931\u8d25: {}", (Object)result);
                throw new BusinessException("\u53d1\u5e03\u5931\u8d25");
            }
            publishModules.forEach(module -> this.ideModuleService.publishHistory((IdeModule)module, "", envUrl));
        }
    }

    @Override
    public Map<String, List<IdeOnline>> viewOnlineHistory(String appId) {
        Map<String, List<IdeOnline>> histories = this.onlineRepo.findByAppId(appId).stream().collect(Collectors.groupingBy(IdeOnline::getOnlineEnvUrl));
        IdeApp app = this.ideAppService.findById(appId);
        String teamId = String.valueOf(app.getTeamId());
        IdeTeam ideTeam = this.ideTeamRepo.findOne(teamId);
        if (ideTeam != null) {
            String teamUrls = ideTeam.getServerUrls();
            if (StringUtils.isEmpty((Object)teamUrls)) {
                return histories;
            }
            List<String> teamUrlList = Arrays.asList(teamUrls.split(","));
            return teamUrlList.stream().collect(Collectors.toMap(url -> url, url -> histories.getOrDefault(url, new ArrayList())));
        }
        return histories;
    }

    @Override
    @Transactional
    public void releaseAppIds(Map<String, Object> appList, String version) {
        Long releaseGroupId = IdWorker.getId();
        appList.keySet().forEach(key -> this.release((String)key, version, (List)appList.get(key), releaseGroupId.toString()));
    }

    @Override
    @Transactional
    public void deleteVersion(String releaseGroupId) {
        this.onlineRepo.deleteByGroupId(releaseGroupId);
        this.releasePageRepo.deleteByGroupId(releaseGroupId);
        this.releaseRepo.deleteByGroupId(releaseGroupId);
    }
}

