package com.ejianc.foundation.front.business.ide.cache;

import java.util.Set;

import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;

@Component
public class IdeModulePageCache {

	public static final String DEFAULT_CHARSET = "UTF-8";

	// 当前appCode和pageCode的所有cacheKey
	private final static String MODULEPAGE_CACHE_KEYS = "modulepage_cache_keys:";
	// 当前模块的缓存Key
	private final static String CURRENT_MODULEPAGE_KEY = "current_modulepage_key:";

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	/**
	 * 前端页面放入缓存
	 * 
	 * @param appCode
	 * @param pageCode
	 * @param orgId
	 */
	public void putModulePageCache(String appCode, String pageCode, String orgId, Object modulePro) {
		String modulePageCacheKey = MODULEPAGE_CACHE_KEYS + appCode + "-" + pageCode;
		String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		if (StringUtils.isNotBlank(orgId)) {
			currentModulePageKey = currentModulePageKey + "-" + orgId;
		}
		String jsonStr = JSONObject.toJSONString(modulePro);

		redisTemplate.opsForValue().set(currentModulePageKey, jsonStr);
		redisTemplate.opsForHash().put(modulePageCacheKey, currentModulePageKey, currentModulePageKey);
 	} 

	/**
	 * 从redis中获取前端页面
	 * 
	 * @param appCode
	 * @param pageCode
	 * @param orgId
	 * @return
	 */
	public Object getModulePageCache(String appCode, String pageCode, String orgId) {
		String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		if (StringUtils.isNotBlank(orgId)) {
			currentModulePageKey = currentModulePageKey + "-" + orgId;
		}
		String jsonStr = (String) redisTemplate.opsForValue().get(currentModulePageKey);
		if (StringUtils.isNotBlank(jsonStr)) {
			/** 读取的私有化页面 */
			System.out.println("读取的私有化页面 "+appCode+"  "+pageCode+"  "+orgId);
			return JSONObject.parseObject(jsonStr, IdeModulePrivate.class);
		}
		currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		System.out.println("读取公共页面 "+appCode+"  "+pageCode+"  "+orgId);
		jsonStr = (String) redisTemplate.opsForValue().get(currentModulePageKey);
		return JSONObject.parseObject(jsonStr, IdeModule.class);
	}

	/**
	 * 当前页面变动时或私有化后，删除该appCode和pageCode下所有缓存
	 * 
	 * @param appCode
	 * @param pageCode
	 */
	public void removeModulePageCache(String appCode, String pageCode) {
		String modulePageCacheKey = MODULEPAGE_CACHE_KEYS + appCode + "-" + pageCode;
		Set<Object> modulePageKeys = redisTemplate.opsForHash().keys(modulePageCacheKey);
		if(modulePageKeys != null && modulePageKeys.size() > 0) {
			for(Object key:modulePageKeys) {
				redisTemplate.delete(key.toString());
			}
		}
		redisTemplate.delete(modulePageCacheKey);
	}

}
