package com.ejianc.foundation.front.business.ide.controller;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 页面管理服务
 */
@RestController
@RequestMapping(value = "/ide/module")
public class IdeModuleController implements Constant{
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleController.class);
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeModulePageCache ideModulePageCache;

    /**
     * 通过应用编码获取应用信息
     * @param code
     * @return
     */
    @RequestMapping(value="findcode",method = RequestMethod.GET)
    public JsonBackData findByCode(String code) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		IdeModule ideModule = ideModuleService.findByCode(code);
    		backData.setBackData(ideModule);
    		backData.setBackMsg("成功");
    	} catch (Exception e) {
    		e.printStackTrace();
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeModule ideModule) throws BusinessException, Exception {
        try {
        	IdeModule module = ideModuleService.saveOrUpdate(ideModule);
			IdeModuleBo bo = ideModuleService.findById(module.getId()+"");
			LOGGER.info("向缓存写入页面数据！save {}---{}---{}",bo.getAppCode(), bo.getCode(), JSONObject.toJSONString(ideModule));
			ideModulePageCache.putModulePageCache(ideModule.getAppCode(), ideModule.getCode(), null,ideModule);
            return JsonBackData.toSuccess("保存成功",module);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }

    }

    @RequestMapping(value = "{id}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable String id) throws Exception {
        try {
			IdeModuleBo module = ideModuleService.findById(id);
            ideModuleService.deleteById(id);
            ideModulePageCache.removeModulePageCache(module.getAppCode(),module.getCode());
            return JsonBackData.toSuccess("删除成功");            
        } catch (Exception e) {
            e.printStackTrace();            
            return JsonBackData.toError(e.getMessage());
        }

    }

    @RequestMapping(value="{id}",method = RequestMethod.GET)
    public JsonBackData module(@PathVariable String id) {
        try {
            IdeModuleBo ideModuleBo = ideModuleService.findById(id);
            return JsonBackData.toSuccess("",ideModuleBo);            
        } catch (Exception e) {
            e.printStackTrace();
        	return JsonBackData.toError(e.getMessage());
        }
    }

    /**
     * 查询页面增加redis缓存------2023-01-14
     * 
     * @param appCode
     * @param pageCode
     * @param mode
     * @param orgId
     * @param tenantId
     * @param request
     * @return
     */
    @RequestMapping(value="findByAppCodeAndPageCode",method = RequestMethod.GET)
    public JsonBackData findByAppCodeAndPageCode(String appCode,String pageCode,
												 String mode,
												 @RequestParam(name="orgId",required=false) String orgId,
												 @RequestParam(name="tenantId",required=false) String tenantId,
												 HttpServletRequest request
	) {
		String authority = request.getHeader(ReferConstant.HEAD_authority);
		String locale = null;//语言选择
		if(StringUtils.isNotBlank(authority)) {
			//从authority获取多语参数
			String[] ac = authority.split(";");
			for (String s : ac) {
				String[] cookieArr = s.split("=");
				if("u_locale".equals(cookieArr[0])) {
					locale = cookieArr[1];
					break;
				}
			}
		}
        try {
        	Object ideModule = ideModulePageCache.getModulePageCache(appCode, pageCode, orgId);
        	
        	if(ideModule == null) {
        		if(StringUtils.isNotEmpty(pageCode) && pageCode.startsWith("CFS")){
        			ideModule = ideModuleService.findByCode(pageCode);
        			if(StringUtils.isNotEmpty(locale) && locale.equals("en")){
        				IdeModule pro = (IdeModule)ideModule;
        				if(StringUtils.isNotEmpty(pro.getEnData())){
        					pro.setData(pro.getEnData());
        					pro.setEnData(null);
        				}
        				ideModule = pro;
        			}
        		}else {
        			if (PAGE_MODE_PRO.equals(mode)) {
        				ideModule = ideModuleProService.findByAppCodeAndModuleCode(appCode,pageCode);
        				if(StringUtils.isNotEmpty(locale) && locale.equals("en")){
        					IdeModulePro pro = (IdeModulePro)ideModule;
        					if(StringUtils.isNotEmpty(pro.getEnData())){
        						pro.setData(pro.getEnData());
        						pro.setEnData(null);
        					}
        					ideModule = pro;
        				}
        			} else {
        				ideModule = ideModuleService.findByAppCodeAndModuleCodeAndOrgId(appCode,pageCode,orgId,tenantId);
        				if(StringUtils.isNotEmpty(locale) && locale.equals("en")){
        					IdeModule pro = (IdeModule)ideModule;
        					if(StringUtils.isNotEmpty(pro.getEnData())){
        						pro.setData(pro.getEnData());
        						pro.setEnData(null);
        					}
        					ideModule = pro;
        				}
        			}
        		}
        		if(ideModule != null) {
        			if(ideModule instanceof IdeModulePrivate){
						LOGGER.info("向缓存写入页面数据！私有化页面{}---{}---{}",appCode, pageCode, orgId);
        				/** 私有化页面 */
						ideModulePageCache.putModulePageCache(appCode, pageCode, orgId, ideModule);
					}else {
						LOGGER.info("向缓存写入页面数据！公共页面 {}---{}---{}",appCode, pageCode, orgId);
						ideModulePageCache.putModulePageCache(appCode, pageCode, null, ideModule);
					}
        		}
        	}else {
        		LOGGER.info("从缓存读取页面数据！{}",JSONObject.toJSONString(ideModule));
			}

            return JsonBackData.toSuccess("", ideModule);
        } catch (Exception e) {
            e.printStackTrace();
			LOGGER.error("出错啦！"+e.getMessage());
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value="copy",method = RequestMethod.POST)
    public JsonBackData copy(@RequestBody IdeModule ideModule) {
        try {
            ideModuleService.copyModule(ideModule);
            return JsonBackData.toSuccess();
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
    
    /**
     * 备份设计页面json数据
     * @param moduleId
     * @param filename
     * @param response
     */
    @RequestMapping(value = "backup/{moduleId}", method = RequestMethod.GET)
	public void backup(@PathVariable("moduleId") String moduleId, String filename, HttpServletResponse response) {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
	    response.setHeader("Content-Disposition", "attachment; filename=\""+ filename +".txt\"");
	    try {
	        OutputStream outputStream = response.getOutputStream();
	        // 获取页面json数据
	        String data = ideModuleService.findById(moduleId).getData();
	        outputStream.write(data.getBytes());
	        outputStream.flush();
	        outputStream.close();
	    } catch (BusinessException e) {
	    	e.printStackTrace();
	    } catch(Exception e) {
	    	e.printStackTrace();
	    }
	}
    
    /**
     * 导入的json数据直接更新保存到对应页面配置信息
     */
    @Deprecated
    @RequestMapping(value="restore",method=RequestMethod.POST)
    public JsonBackData restore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
    	try {
    		// 上传的数据转成string
        	ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			// 验证
			IdeModule ideModule = ideModuleService.findEntityById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModule.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData!=null && oldData.get("uitype").equals(newData.get("uitype")); 
			if(valide || oldData==null){
				// 保存data
				ideModule.setModifyDate(new Date());
				ideModule.setData(myString);
				ideModuleService.saveOrUpdate(ideModule);
				return JsonBackData.toSuccess();

			} else {
				return JsonBackData.toError("页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError(e.getMessage());
		}
    }
    /**
     * 将导入的json数据直接返回到前端
     */
    @RequestMapping(value="getrestore",method=RequestMethod.POST)
    public JsonBackData getRestore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
    	try {
    		// 上传的数据转成string
        	ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			IdeModule ideModule = ideModuleService.findEntityById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModule.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData!=null && oldData.get("uitype").equals(newData.get("uitype")); 
			if(valide || oldData==null){
				return JsonBackData.toSuccessData(myString);
			} else {
				return JsonBackData.toError("导入失败：页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError("导入异常："+e.getMessage());
		}
    }
    /**
     * 发布页面（同步数据到目标环境的数据库）
     * @return
     */
    @ResponseBody
    @RequestMapping(value="syncpublish",method = RequestMethod.POST)
    public JsonBackData syncPages(String appId, @RequestParam("pageIds") List<String> pageIds,String fromName,String toName) {
    	try{
	    	JsonBackData backData = ideModuleService.syncPublishProduction(appId, pageIds, fromName, toName);
	    	return backData;
    	}catch(Exception e){
    		return JsonBackData.toError(e.getMessage());
    	}
    }
    
    @ResponseBody
    @RequestMapping(value="move",method = RequestMethod.POST)
    public JsonBackData movePage(String appId, String[] pageIds) {
    		List<String> pageIdList = Arrays.asList(pageIds);
    		try{
    			JsonBackData jsonBackData = ideModuleService.movePage(pageIdList, appId);
    			return jsonBackData;
    		} catch(Exception e) {
    			e.printStackTrace();
        		return JsonBackData.toError(e.getMessage());
    		}
    }
    
    
}