package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.utils.SqlBuildUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.service.SqlExportService;
import com.ejianc.framework.core.exception.BusinessException;

@Service
@Transactional
public class SqlExportServiceImpl implements SqlExportService{

	@Autowired
	IdeAppRepo ideAppRepo;
	@Autowired
	IdeModuleRepo ideModuleRepo;
	@Autowired
	IdeTeamRepo teamRepo;
	@Override
	public List<String> exportSql(HttpServletRequest req, List<String> appCodes,List<String> teamCodes) throws BusinessException, Exception {
		if (appCodes.size()>0 && appCodes != null) {
			String appCodesParam = "(";
			for(String appCode : appCodes){
				appCodesParam=appCodesParam+"'"+appCode+"',";
			}
			appCodesParam = appCodesParam.substring(0,appCodesParam.length() - 1);
			appCodesParam += ")";
			String teamCodesParam = "(";
			for(String teamCode : teamCodes){
				teamCodesParam=teamCodesParam+"'"+teamCode+"',";
			}
			teamCodesParam = teamCodesParam.substring(0,teamCodesParam.length() - 1);
			teamCodesParam += ")";
			String findAppSql = "select t1.id ,t1.code ,t1.name,t1.is_open isOpen,t1.group_id groupId,t1.resource_data resourceData,t1.team_id teamId,t1.bill_type_code billTypeCode,t1.bill_type_name billTypeName "
					+ "from ide_app t1 where t1.is_delete = 0 and t1.code in "+appCodesParam;
			String selectAppSql = " select id from ide_app where is_delete = 0 and code in "+appCodesParam;
			String findModuleSql = "select t1.id,t1.code,t1.name,t1.data,t1.from_id fromId,"
					+ "t1.from_name fromName,t1.group_id groupId,t1.page_type pageType,t1.app_id appId "
					+ "from ide_module t1 where t1.is_delete = 0 and t1.app_id in ("+selectAppSql+")";
			String findTeamSql = "select t1.id ,t1.code ,t1.name,t1.member_count memberCount,t1.app_count appCount,t1.prod_type prodType,t1.server_urls serverUrls "
					+ "from ide_team t1 where t1.is_delete = 0 and t1.code in "+teamCodesParam;
			List<IdeApp> appData = ideAppRepo.findListBySql(appCodesParam);
			List<IdeModule> moduleData = ideModuleRepo.findListBySql(appCodesParam);
			List<IdeTeam> teamData = teamRepo.findListBySql(teamCodesParam);
			Map<String, Object> deletemoduleCodes = new HashMap<>();
			List<String> moduleCodes = new ArrayList<>();
			Map<String, Object> deleteappCodes = new HashMap<>();
			List<String> insertApp = new ArrayList<>();
			for (IdeApp ideApp : appData) {
				//"脚本导入" 账号创建者使用1000000
				ideApp.setCreateId(1000000L);
				ideApp.setIsDelete(0);
				insertApp.add(SqlBuildUtil.createInsertIdeAppSql(ideApp));
			}
			List<String> insertModule = new ArrayList<>();
			for (IdeModule ideModule : moduleData) {
				ideModule.setCreateId(1000000L);
				ideModule.setIsDelete(0);
				moduleCodes.add(ideModule.getCode());
				insertModule.add(SqlBuildUtil.createInsertIdeModuleSql(ideModule));
			}
			List<String> insertTeam = new ArrayList<>();
			for (IdeTeam ideTeam : teamData) {
				ideTeam.setCreateId(1000000L);
				ideTeam.setIsDelete(0);
				insertModule.add(SqlBuildUtil.createInsertIdeTeamSql(ideTeam));
			}
			deleteappCodes.put("code", appCodes);
			deletemoduleCodes.put("code", moduleCodes);
			List<String> sqlText = new ArrayList<>();
			selectAppSql = " select id from `ejc-front`.`ide_app` where  code in "+appCodesParam;
			String deleteModule = "delete from `ejc-front`.`ide_module` where 1=1  and app_id in ("+selectAppSql+");";
			String deleteApp = "delete from `ejc-front`.`ide_app` where 1=1  and code in  "+appCodesParam+" ;";
			String deleteTeam = "delete from `ejc-front`.`ide_team` where 1=1  and code in "+teamCodesParam+" ;";
			sqlText.add(deleteModule);
			sqlText.add(deleteApp);
			sqlText.add(deleteTeam);
			sqlText.addAll(insertTeam);
			sqlText.addAll(insertApp);
			sqlText.addAll(insertModule);
			return sqlText;
		}else {
			throw new BusinessException("未选择应用!");
		}
		
	}

}
