/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"/ide/module"})
public class IdeModuleController
implements Constant {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleController.class);
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeModulePageCache ideModulePageCache;

    @RequestMapping(value={"findcode"}, method={RequestMethod.GET})
    public JsonBackData findByCode(String code) {
        JsonBackData backData = new JsonBackData();
        try {
            IdeModule ideModule = this.ideModuleService.findByCode(code);
            backData.setBackData(ideModule);
            backData.setBackMsg("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeModule ideModule) throws BusinessException, Exception {
        try {
            IdeModule module = this.ideModuleService.saveOrUpdate(ideModule);
            IdeModuleBo bo = this.ideModuleService.findById(module.getId() + "");
            LOGGER.info("\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01save {}---{}---{}", new Object[]{bo.getAppCode(), bo.getCode(), JSONObject.toJSONString((Object)ideModule)});
            this.ideModulePageCache.removeModulePageCache(bo.getAppCode(), bo.getCode(), null);
            return JsonBackData.toSuccess("\u4fdd\u5b58\u6210\u529f", module);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable String id) throws Exception {
        try {
            IdeModuleBo module = this.ideModuleService.findById(id);
            this.ideModuleService.deleteById(id);
            LOGGER.info("\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01delete {}---{}---{}", new Object[]{module.getAppCode(), module.getCode(), null});
            this.ideModulePageCache.removeModulePageCache(module.getAppCode(), module.getCode(), null);
            return JsonBackData.toSuccess("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData module(@PathVariable String id) {
        try {
            IdeModuleBo ideModuleBo = this.ideModuleService.findById(id);
            return JsonBackData.toSuccess("", ideModuleBo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"findByAppCodeAndPageCode"}, method={RequestMethod.GET})
    public JsonBackData findByAppCodeAndPageCode(String appCode, String pageCode, String mode, @RequestParam(name="orgId", required=false) String orgId, @RequestParam(name="tenantId", required=false) String tenantId, HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String locale = null;
        if (StringUtils.isNotBlank(authority)) {
            String[] ac;
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                if (!"u_locale".equals(cookieArr[0])) continue;
                locale = cookieArr[1];
                break;
            }
        }
        try {
            Object ideModule = this.ideModulePageCache.getModulePageCache(appCode, pageCode, orgId);
            if (ideModule == null) {
                Serializable pro;
                if (StringUtils.isNotEmpty(pageCode) && pageCode.startsWith("CFS")) {
                    ideModule = this.ideModuleService.findByCode(pageCode);
                    if (StringUtils.isNotEmpty(locale) && locale.equals("en")) {
                        pro = (IdeModule)ideModule;
                        if (StringUtils.isNotEmpty(((IdeModule)pro).getEnData())) {
                            ((IdeModule)pro).setData(((IdeModule)pro).getEnData());
                            ((IdeModule)pro).setEnData(null);
                        }
                        ideModule = pro;
                    }
                } else if ("product".equals(mode)) {
                    ideModule = this.ideModuleProService.findByAppCodeAndModuleCode(appCode, pageCode);
                    if (StringUtils.isNotEmpty(locale) && locale.equals("en")) {
                        pro = (IdeModulePro)ideModule;
                        if (StringUtils.isNotEmpty(((IdeModulePro)pro).getEnData())) {
                            ((IdeModulePro)pro).setData(((IdeModulePro)pro).getEnData());
                            ((IdeModulePro)pro).setEnData(null);
                        }
                        ideModule = pro;
                    }
                } else {
                    ideModule = this.ideModuleService.findByAppCodeAndModuleCodeAndOrgId(appCode, pageCode, orgId, tenantId);
                    if (StringUtils.isNotEmpty(locale) && locale.equals("en")) {
                        pro = (IdeModule)ideModule;
                        if (StringUtils.isNotEmpty(((IdeModule)pro).getEnData())) {
                            ((IdeModule)pro).setData(((IdeModule)pro).getEnData());
                            ((IdeModule)pro).setEnData(null);
                        }
                        ideModule = pro;
                    }
                }
                if (ideModule != null) {
                    if (ideModule instanceof IdeModulePrivate) {
                        LOGGER.info("\u5411\u7f13\u5b58\u5199\u5165\u9875\u9762\u6570\u636e\uff01\u79c1\u6709\u5316\u9875\u9762{}---{}---{}", new Object[]{appCode, pageCode, orgId});
                        this.ideModulePageCache.putModulePageCache(appCode, pageCode, orgId, ideModule);
                    } else {
                        LOGGER.info("\u5411\u7f13\u5b58\u5199\u5165\u9875\u9762\u6570\u636e\uff01\u516c\u5171\u9875\u9762 {}---{}---{}", new Object[]{appCode, pageCode, orgId});
                        this.ideModulePageCache.putModulePageCache(appCode, pageCode, null, ideModule);
                    }
                }
            } else {
                LOGGER.info("\u4ece\u7f13\u5b58\u8bfb\u53d6\u9875\u9762\u6570\u636e\uff01{}---{}---{}", new Object[]{appCode, pageCode, orgId});
            }
            if (ideModule == null) {
                return JsonBackData.toError("\u9875\u9762\u5c1a\u672a\u53d1\u5e03\uff01");
            }
            return JsonBackData.toSuccess("\u67e5\u8be2\u6210\u529f\uff01", ideModule);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u51fa\u9519\u5566\uff01" + e.getMessage());
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"copy"}, method={RequestMethod.POST})
    public JsonBackData copy(@RequestBody IdeModule ideModule) {
        try {
            this.ideModuleService.copyModule(ideModule);
            return JsonBackData.toSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"backup/{moduleId}"}, method={RequestMethod.GET})
    public void backup(@PathVariable(value="moduleId") String moduleId, String filename, HttpServletResponse response) {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + ".txt\"");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            String data = this.ideModuleService.findById(moduleId).getData();
            outputStream.write(data.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (BusinessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    @RequestMapping(value={"restore"}, method={RequestMethod.POST})
    public JsonBackData restore(@RequestParam(value="file") CommonsMultipartFile file, String pageId) {
        try {
            boolean valide;
            ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
            String myString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            IdeModule ideModule = this.ideModuleService.findEntityById(pageId);
            JSONObject newData = JSONObject.parseObject((String)myString);
            JSONObject oldData = JSONObject.parseObject((String)ideModule.getData());
            boolean bl = valide = oldData != null && oldData.get((Object)"uitype").equals(newData.get((Object)"uitype"));
            if (valide || oldData == null) {
                ideModule.setModifyDate(new Date());
                ideModule.setData(myString);
                this.ideModuleService.saveOrUpdate(ideModule);
                return JsonBackData.toSuccess();
            }
            return JsonBackData.toError("\u9875\u9762\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"getrestore"}, method={RequestMethod.POST})
    public JsonBackData getRestore(@RequestParam(value="file") CommonsMultipartFile file, String pageId) {
        try {
            boolean valide;
            ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
            String myString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            IdeModule ideModule = this.ideModuleService.findEntityById(pageId);
            JSONObject newData = JSONObject.parseObject((String)myString);
            JSONObject oldData = JSONObject.parseObject((String)ideModule.getData());
            boolean bl = valide = oldData != null && oldData.get((Object)"uitype").equals(newData.get((Object)"uitype"));
            if (valide || oldData == null) {
                return JsonBackData.toSuccessData(myString);
            }
            return JsonBackData.toError("\u5bfc\u5165\u5931\u8d25\uff1a\u9875\u9762\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @ResponseBody
    @RequestMapping(value={"syncpublish"}, method={RequestMethod.POST})
    public JsonBackData syncPages(String appId, @RequestParam(value="pageIds") List<String> pageIds, String fromName, String toName) {
        try {
            JsonBackData backData = this.ideModuleService.syncPublishProduction(appId, pageIds, fromName, toName);
            return backData;
        }
        catch (Exception e) {
            return JsonBackData.toError(e.getMessage());
        }
    }

    @ResponseBody
    @RequestMapping(value={"move"}, method={RequestMethod.POST})
    public JsonBackData movePage(String appId, String[] pageIds) {
        List<String> pageIdList = Arrays.asList(pageIds);
        try {
            JsonBackData jsonBackData = this.ideModuleService.movePage(pageIdList, appId);
            return jsonBackData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
}

