/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleDataBO;
import com.ejianc.foundation.front.business.ide.service.IdeModuleDataService;
import com.ejianc.foundation.front.util.JsonBackData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/ide/data"})
@RestController
public class IdeModuleDataController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleDataController.class);
    private static Set<String> runningUsers = new HashSet<String>();
    private static Set<String> runningModules = new HashSet<String>();
    @Autowired
    private IdeModuleDataService moduleDataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"parseByUser/{userId}"})
    public JsonBackData parseByUser(@PathVariable String userId) {
        JsonBackData backData = new JsonBackData();
        if (runningUsers.contains(userId)) {
            backData.setSuccess(false);
            backData.setBackMsg("\u89e3\u6790\u4e2d...\u8bf7\u8010\u5fc3\u7b49\u5f85");
        } else {
            try {
                runningUsers.add(userId);
                this.moduleDataService.createFromUser(userId);
                backData.setBackMsg("\u89e3\u6790\u6210\u529f");
            }
            catch (Exception e) {
                LOGGER.error("\u89e3\u6790\u5931\u8d25", (Throwable)e);
                backData.setSuccess(false);
                backData.setBackMsg("\u89e3\u6790\u5931\u8d25");
            }
            finally {
                runningUsers.remove(userId);
            }
        }
        return backData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"parseByPage/{moduleId}"})
    public JsonBackData parseModule(@PathVariable String moduleId) {
        JsonBackData backData = new JsonBackData();
        if (runningModules.contains(moduleId)) {
            backData.setSuccess(false);
            backData.setBackMsg("\u89e3\u6790\u4e2d...\u8bf7\u8010\u5fc3\u7b49\u5f85");
        } else {
            try {
                runningModules.add(moduleId);
                this.moduleDataService.createFromIdeModule(moduleId);
                backData.setBackMsg("\u89e3\u6790\u6210\u529f");
            }
            catch (Exception e) {
                LOGGER.error("\u89e3\u6790\u5931\u8d25", (Throwable)e);
                backData.setSuccess(false);
                backData.setBackMsg("\u89e3\u6790\u5931\u8d25");
            }
            finally {
                runningModules.remove(moduleId);
            }
        }
        return backData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"parseByPages"}, method={RequestMethod.POST})
    public JsonBackData parseModules(String[] moduleIds) {
        JsonBackData backData = new JsonBackData();
        List<String> moduleIdList = Arrays.asList(moduleIds);
        if (runningModules.stream().anyMatch(moduleIdList::contains)) {
            backData.setSuccess(false);
            backData.setBackMsg("\u6709\u6a21\u5757\u6b63\u5728\u89e3\u6790\u4e2d...\u8bf7\u8010\u5fc3\u7b49\u5f85");
        } else {
            for (String moduleId : moduleIdList) {
                try {
                    runningModules.add(moduleId);
                    this.moduleDataService.createFromIdeModule(moduleId);
                }
                catch (Exception e) {
                    LOGGER.error("\u89e3\u6790\u5931\u8d25", (Throwable)e);
                    backData.setSuccess(false);
                    backData.setBackMsg("\u89e3\u6790\u5931\u8d25");
                    JsonBackData jsonBackData = backData;
                    return jsonBackData;
                }
                finally {
                    runningModules.remove(moduleId);
                }
            }
            backData.setBackMsg("\u89e3\u6790\u6210\u529f");
        }
        return backData;
    }

    @RequestMapping(value={"findDataByEntity"}, method={RequestMethod.GET})
    public JsonBackData module(String entityName) {
        try {
            List<IdeModuleDataBO> ideModuleDataBOs = this.moduleDataService.findDataByEntity(entityName);
            return JsonBackData.toSuccess("", ideModuleDataBOs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
}

