/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.service.IdeReleaseService;
import com.ejianc.foundation.front.util.JsonBackData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/release"})
public class IdeReleaseController {
    private static final Logger log = LoggerFactory.getLogger(IdeReleaseController.class);
    @Autowired
    private IdeReleaseService releaseService;

    @ResponseBody
    @RequestMapping(value={"release"}, method={RequestMethod.POST})
    public JsonBackData release(@RequestBody Map<String, Object> params) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        String version = (String)params.get("version");
        Map appList = (Map)params.get("appList");
        try {
            this.releaseService.releaseAppIds(appList, version);
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u53d1\u7248\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findReleases"}, method={RequestMethod.GET})
    public JsonBackData findReleases(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.findReleases(appId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u83b7\u53d6\u7248\u672c\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findReleasePages"}, method={RequestMethod.GET})
    public JsonBackData findReleasePages(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.findReleasePages(releaseGroupId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u83b7\u53d6\u53d1\u7248\u9875\u9762\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"online"}, method={RequestMethod.GET})
    public JsonBackData online(String releaseGroupId, String envUrl) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            this.releaseService.online(releaseGroupId, envUrl);
        }
        catch (Exception e) {
            log.error("\u4e0a\u7ebf\u5931\u8d25\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u4e0a\u7ebf\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"viewOnlineHistory"}, method={RequestMethod.GET})
    public JsonBackData viewOnlineHistory(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.viewOnlineHistory(appId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u770b\u4e0a\u7ebf\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"deleteVersion"}, method={RequestMethod.GET})
    public JsonBackData deleteVersion(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            this.releaseService.deleteVersion(releaseGroupId);
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u770b\u4e0a\u7ebf\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
        return back;
    }
}

