/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleDataBO;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataBoRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModuleDataService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class IdeModuleDataServiceImpl
implements IdeModuleDataService {
    private static final String NID = "nid";
    private static final String UI_KEY = "uikey";
    private static final String UI_TITLE = "uititle";
    private static final String UI_TYPE = "uitype";
    private static final String CHILDREN = "children";
    private static final Set<String> FIXED_KEYS = new HashSet<String>(Arrays.asList("nid", "uikey", "uititle", "uitype", "children"));
    @Autowired
    private IdeModuleDataRepo moduleDataRepo;
    @Autowired
    private IdeModuleRepo moduleRepo;
    @Autowired
    private IdeModuleDataBoRepo moduleDataRepoImpl;

    @Override
    @Transactional
    public IdeModuleData createFromIdeModule(String moduleId) {
        IdeModule module = (IdeModule)this.moduleRepo.selectById((Serializable)((Object)moduleId));
        if (module != null) {
            return this.createFromIdeModule(module);
        }
        return null;
    }

    @Override
    @Transactional
    public Map<Long, IdeModuleData> createFromIdeModules(List<String> moduleIds) {
        if (!CollectionUtils.isEmpty(moduleIds)) {
            return moduleIds.stream().map(this::createFromIdeModule).filter(Objects::nonNull).collect(Collectors.toMap(moduleData -> moduleData.getModule().getId(), moduleData -> moduleData));
        }
        return null;
    }

    @Override
    public IdeModuleData createFromIdeModule(IdeModule module) {
        JSONObject data;
        IdeModuleData moduleData;
        IdeModuleData _moduleData = this.moduleDataRepo.findByModuleId(module.getId());
        if (_moduleData != null) {
            this.moduleDataRepo.deleteById(_moduleData.getId());
        }
        if ((moduleData = this.parseJSONObject(data = JSONObject.parseObject((String)module.getData()), null, module)) != null) {
            this.moduleDataRepo.insert(moduleData);
            return moduleData;
        }
        return null;
    }

    private IdeModuleData parseJSONObject(JSONObject jsonObject, IdeModuleData parent, IdeModule module) {
        if (jsonObject != null) {
            IdeModuleData moduleData = new IdeModuleData();
            moduleData.setModule(module);
            moduleData.setAppId(module.getAppId());
            moduleData.setParent(parent);
            moduleData.setRoot(parent == null);
            moduleData.setNid(jsonObject.getString(NID));
            moduleData.setUikey(jsonObject.getString(UI_KEY));
            moduleData.setUititle(jsonObject.getString(UI_TITLE));
            moduleData.setUitype(jsonObject.getString(UI_TYPE));
            Map<String, Object> otherData = jsonObject.keySet().stream().filter(key -> !FIXED_KEYS.contains(key) || key.equals(CHILDREN) && !(jsonObject.get((Object)CHILDREN) instanceof JSONArray)).filter(key -> jsonObject.get(key) != null).peek(key -> System.out.println("key: " + key + ", value: " + jsonObject.get(key))).collect(Collectors.toMap(key -> key, arg_0 -> ((JSONObject)jsonObject).get(arg_0)));
            moduleData.setData(CollectionUtils.isEmpty(otherData) ? null : JSONObject.toJSONString(otherData));
            if (jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
                List<IdeModuleData> children = jsonObject.getJSONArray(CHILDREN).stream().map(item -> this.parseJSONObject((JSONObject)item, moduleData, module)).collect(Collectors.toList());
                moduleData.setChildren(children);
            }
            return moduleData;
        }
        return null;
    }

    @Override
    public List<IdeModuleData> createFromIdeApp(String appId) {
        List<IdeModule> ideModules = this.moduleRepo.findByAppId(appId);
        return ((List)Optional.ofNullable(ideModules).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(this::createFromIdeModule).collect(Collectors.toList());
    }

    @Override
    public List<IdeModuleData> createFromUser(String userId) {
        List<IdeModule> ideModules = this.moduleRepo.findByUserId(userId);
        return ((List)Optional.ofNullable(ideModules).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(this::createFromIdeModule).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<IdeModuleData>> findByModuleIdsAndUitypes(List<String> moduleIds, List<String> uiTypes) {
        String moduleids = "'" + StringUtils.join(moduleIds, (String)"','") + "'";
        String types = "'" + StringUtils.join(uiTypes, (String)"','") + "'";
        List<IdeModuleData> moduleDataList = this.moduleDataRepo.findByModuleIdsAndUitypes(moduleids, types);
        Map<String, List<IdeModuleData>> moduleDataMap = moduleDataList.stream().collect(Collectors.groupingBy(moduleData -> String.valueOf(moduleData.getModule().getId())));
        moduleDataMap.forEach((key, value) -> value.forEach(item -> {
            item.setModule(null);
            item.setParent(null);
            item.setChildren(null);
        }));
        return moduleDataMap;
    }

    @Override
    public List<IdeModuleDataBO> findDataByEntity(String entityName) {
        List<IdeModuleDataBO> allData;
        if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)entityName) && (allData = this.moduleDataRepoImpl.findDataByEntity(entityName)) != null && allData.size() > 0) {
            List result = allData.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IdeModuleDataBO>(Comparator.comparing(IdeModuleDataBO::getUikey))), ArrayList::new));
            return result;
        }
        return null;
    }
}

