/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeModuleServiceImpl
implements IdeModuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleServiceImpl.class);
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModuleRepo ideModuleRepoImpl;
    @Autowired
    IdeTeamRepo ideTeamRepo;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModulePrivateService ideModulePrivateService;
    @Autowired
    IdeEnvironmentService ideEnvironmentService;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    private MetadataReaderService metadataReaderService;
    @Autowired
    private ICustomTableApi iCustomTableApi;
    @Autowired
    IdeModulePageCache ideModulePageCache;

    @Override
    @Transactional
    public synchronized IdeModule saveOrUpdate(IdeModule ideModule) throws ClassCastException {
        IdeModule ideModuleTemp = null;
        this.setEnData(ideModule);
        if (ideModule.getId() == null) {
            if (StringUtils.isEmpty(String.valueOf(ideModule.getAppId()))) {
                throw new BusinessException("\u6240\u5c5e\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(ideModule.getName())) {
                throw new BusinessException("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<IdeModule> ideModuleList = this.ideModuleRepo.findByName(ideModule.getName(), String.valueOf(ideModule.getAppId()));
            if (ideModuleList.size() > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u9875\u9762\u540d\u79f0");
            }
            ideModule.setId(IdWorker.getId());
            String code = this.ideCommonService.generateModuleCode();
            ideModule.setCode(code);
            Date nowDate = new Date();
            ideModule.setCreateDate(nowDate);
            if (ideModule.isReadEntityMetadata()) {
                JSONObject data = this.metadataReaderService.readMetadata(ideModule.getBillType(), ideModule.getEntityId().toString(), ideModule.getPageType());
                ideModule.setData(data == null ? null : data.toJSONString());
            }
            this.ideModuleRepo.save(ideModule);
            return ideModule;
        }
        ideModuleTemp = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        if (!Objects.equals(ideModule.getTs(), ideModuleTemp.getTs())) {
            throw new BusinessException("\u6570\u636e\u5df2\u88ab\u56e2\u961f\u5176\u4ed6\u6210\u5458\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u4fee\u6539\u540e\u518d\u6b21\u4fdd\u5b58\uff01");
        }
        ideModuleTemp.setTs(new Date().getTime());
        ideModuleTemp.setName(ideModule.getName());
        if (StringUtils.isNotEmpty(ideModule.getClientType())) {
            ideModuleTemp.setClientType(ideModule.getClientType());
        }
        ideModuleTemp.setModifyDate(new Date());
        ideModuleTemp.setModifyName(ideModule.getModifyName());
        if (ideModule.getData() != null) {
            ideModuleTemp.setData(ideModule.getData());
            ideModuleTemp.setEnData(ideModule.getEnData());
        }
        if (StringUtils.isNotEmpty(String.valueOf(ideModule.getGroupId()))) {
            ideModuleTemp.setGroupId(ideModule.getGroupId());
        }
        if (ideModuleTemp.getCode().startsWith("CFS") && StringUtils.isNotEmpty(ideModule.getFromName())) {
            Long userId = Long.parseLong(ideModule.getFromName().split(":")[0]);
            String token = ideModule.getFromName().split(":")[1];
            PageData pageData = new PageData();
            pageData.setAppCode(ideModuleTemp.getCode());
            pageData.setPageMeta(ideModule.getData());
            pageData.setToken(token);
            pageData.setUserId(userId);
            CommonResponse response = this.iCustomTableApi.parse(pageData);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            ideModuleTemp.setFromName(null);
        }
        this.ideModuleRepo.update(ideModuleTemp);
        return ideModuleTemp;
    }

    private void setEnData(IdeModule ideModule) {
        if (StringUtils.isNotEmpty(ideModule.getData())) {
            JSONObject data = JSONObject.parseObject((String)ideModule.getData());
            this.setUiTitleEn(data);
            if (data.get((Object)"children") != null && data.getString("children").contains("[")) {
                JSONArray children = data.getJSONArray("children");
                this.setChildrenEn(children);
            }
            ideModule.setEnData(JSONObject.toJSONString((Object)data));
        }
    }

    private void setUiTitleEn(JSONObject ui) {
        if (StringUtils.isNotEmpty(ui.getString("enTitle"))) {
            ui.put("uititle", (Object)ui.getString("enTitle"));
            if (ui.getString("children") != null && !ui.getString("children").contains("[")) {
                ui.put("children", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("title") != null) {
                ui.put("title", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("label") != null) {
                ui.put("label", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("buttonText") != null) {
                ui.put("buttonText", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("text") != null) {
                ui.put("text", (Object)ui.getString("enTitle"));
            }
        }
    }

    private void setChildrenEn(JSONArray children) {
        for (Object child : children) {
            JSONObject ui = (JSONObject)child;
            this.setUiTitleEn(ui);
            if (ui.get((Object)"children") == null || !ui.getString("children").contains("[")) continue;
            JSONArray cChildren = ui.getJSONArray("children");
            this.setChildrenEn(cChildren);
        }
    }

    @Override
    public void copyModule(IdeModule ideModule) throws Exception {
        IdeModule ideModuleSrc = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        IdeModule ideModuleSave = new IdeModule();
        ideModuleSave.setId(IdWorker.getId());
        BeanUtils.copyProperties((Object)ideModuleSrc, (Object)ideModuleSave, (String[])new String[]{"id", "fromId", "fromName", "createId", "createDate", "name", "modifyName"});
        ideModuleSave.setCreateId(ideModule.getCreateId());
        ideModuleSave.setCreateDate(new Date());
        ideModuleSave.setName(ideModule.getName());
        String code = this.ideCommonService.generateModuleCode();
        ideModuleSave.setCode(code);
        ideModuleSave.setAppId(ideModule.getAppId());
        ideModuleSave.setGroupId(ideModule.getGroupId());
        ideModuleSave.setFromId(ideModule.getFromId());
        ideModuleSave.setPageType(ideModule.getPageType());
        ideModuleSave.setFromName(ideModule.getFromName());
        this.ideModuleRepo.save(ideModuleSave);
    }

    @Override
    public IdeModule findByCode(String moduleCode) {
        List<IdeModule> ideModules = this.ideModuleRepo.findAllByCode(moduleCode);
        if (ideModules != null && ideModules.size() > 0) {
            return ideModules.get(0);
        }
        return null;
    }

    @Override
    public List<IdeModule> findByAppId(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findDetailsByAppId(appId);
        return ideModules;
    }

    @Override
    public List<IdeModule> findIsDeleteModules(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findModulesByAppId(appId, 1);
        return ideModules;
    }

    @Override
    public void deleteById(String id) throws Exception {
        this.ideModuleRepo.deleteById(id);
        this.ideModulePrivateRepo.deleteByModuleIds(id);
        IdeModuleData moduleData = this.moduleDataRepo.findByModuleId(Long.parseLong(id));
        if (moduleData != null) {
            this.moduleDataRepo.deleteById(moduleData);
        }
    }

    @Override
    public IdeModuleBo findById(String id) throws Exception {
        IdeModuleBo ideModuleBo = this.ideModuleRepoImpl.findDetailById(id);
        if (ideModuleBo == null) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u5907\u4efd\u7684\u9875\u9762");
        }
        return ideModuleBo;
    }

    @Override
    public IdeModule findEntityById(String id) {
        return this.ideModuleRepo.findById(id);
    }

    @Override
    public IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode) {
        LOGGER.info("findByAppCodeAndModuleCode ======== {{}}---{{}}", (Object)appCode, (Object)moduleCode);
        return this.ideModuleRepo.findByAppCodeAndModuleCode(appCode, moduleCode);
    }

    @Override
    public Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String moduleCode, String orgId, String tenantId) {
        IdeModulePrivate orgPage = null;
        if (orgId != null && !"".equals(orgId) && tenantId != null && !"".equals(tenantId)) {
            orgPage = this.ideModulePrivateService.findByOrgId(moduleCode, appCode, orgId, tenantId);
        }
        LOGGER.info("orgPage ======== " + orgPage);
        if (orgPage != null) {
            return orgPage;
        }
        return this.findByAppCodeAndModuleCode(appCode, moduleCode);
    }

    @Override
    public void publishHistory(IdeModule ideModule, String fromName, String toName) {
        IdeModulePro module = new IdeModulePro();
        BeanUtils.copyProperties((Object)ideModule, (Object)module, (String[])new String[]{"id", "createDate", "modifyDate"});
        module.setCreateDate(new Date());
        module.setFromName(fromName);
        module.setToName(toName);
        int maxVer = this.ideModuleProRepo.findMaxVersion(ideModule.getCode(), toName);
        module.setVerNum(++maxVer);
        module.setId(IdWorker.getId());
        module.setCreateDate(new Date());
        this.ideModuleProRepo.save(module);
    }

    @Override
    public List<IdeModule> findInAppIds(String[] appIds) {
        List<IdeModule> modules = new ArrayList<IdeModule>();
        if (appIds == null || appIds.length == 0) {
            return modules;
        }
        String appIdStr = "'" + org.apache.commons.lang.StringUtils.join(Arrays.asList(appIds), (String)"','") + "'";
        modules = this.ideModuleRepo.findInAppIds(appIdStr);
        return modules;
    }

    @Override
    @Transactional
    public JsonBackData syncPublishProduction(String appId, List<String> pageIds, String fromName, String toName) throws Exception {
        if (StringUtils.isEmpty(toName)) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u53d1\u5e03\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        if (pageIds == null || pageIds.size() == 0) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u6ca1\u6709\u53ef\u53d1\u5e03\u7684\u9875\u9762\uff01");
        }
        IdeApp app = this.ideAppService.findById(appId);
        if (app == null) {
            return JsonBackData.toError("\u53d1\u5e03\u7684\u5e94\u7528[" + appId + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        IdeTeamBo team = null;
        if (app.getTeamId() != null) {
            if (!this.ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
                return JsonBackData.toError("\u672c\u56e2\u961f\u88ab\u9650\u5236\u53d1\u5e03\u5e94\u7528\u5230[" + toName + "]\u73af\u5883\uff0c\u53ef\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01");
            }
            IdeTeam teamBean = this.ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
            if (teamBean != null) {
                team = new IdeTeamBo(teamBean);
            }
        }
        ArrayList<String> notExistPages = new ArrayList<String>();
        List failPages = new ArrayList();
        IdeProductionBo postData = new IdeProductionBo();
        postData.setIdeTeam(team);
        postData.setIdeApp(new IdeAppBo(app));
        postData.setFromName(fromName);
        postData.setToName(toName);
        List<IdeModule> publishModules = new ArrayList<IdeModule>();
        for (String moduleId : pageIds) {
            IdeModule module = this.findEntityById(moduleId);
            if (module == null) {
                notExistPages.add(moduleId);
                continue;
            }
            module.setAppCode(app.getCode());
            publishModules.add(module);
        }
        if ((publishModules = this.ideModuleProService.findDiffLastPublish(publishModules, toName)).size() == 0) {
            return JsonBackData.toSuccess("\u6240\u53d1\u5e03\u9875\u9762\u4e0e\u6700\u65b0\u7248\u672c\u76f8\u540c\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03");
        }
        for (IdeModule ideModule : publishModules) {
            postData.getIdeModules().add(new IdeModuleBo(ideModule));
        }
        ObjectMapper mapper = new ObjectMapper();
        String postJson = mapper.writeValueAsString((Object)postData);
        LOGGER.info("\u53d1\u9001\u6570\u636e\uff1a" + postJson);
        HttpResponse httpresponse = HttpClientUtil.postJSON(toName + "/ejc-front-web/ide/production/syncreceive", postJson);
        if (httpresponse == null) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
        }
        int resCode = httpresponse.getStatusLine().getStatusCode();
        if (resCode != 200) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + resCode);
        }
        JSONObject resultObj = null;
        String result = EntityUtils.toString((HttpEntity)httpresponse.getEntity());
        try {
            resultObj = (JSONObject)JSONObject.parse((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(result);
        }
        JsonBackData jsonBackData = new JsonBackData();
        jsonBackData.setSuccess(resultObj.getBoolean("success"));
        jsonBackData.setBackData(resultObj.get((Object)"backData"));
        jsonBackData.setBackMsg(resultObj.getString("backMsg"));
        if (jsonBackData.isSuccess()) {
            for (IdeModule module : publishModules) {
                this.publishHistory(module, fromName, toName);
            }
        } else {
            return jsonBackData;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        failPages = (List)objectMapper.readValue(objectMapper.writeValueAsString(jsonBackData.getBackData()), (TypeReference)new TypeReference<ArrayList<String>>(){});
        if (notExistPages.size() > 0 || failPages.size() > 0) {
            HashMap<String, Object> backData = new HashMap<String, Object>();
            backData.put("notExist", notExistPages.size());
            backData.put("failPages", failPages);
            return JsonBackData.toSuccess("\u53d1\u5e03\u5b8c\u6210", backData);
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f");
    }

    @Override
    @Transactional
    public JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception {
        IdeAppBo appBo;
        IdeApp ideApp;
        LOGGER.info("\u63a5\u6536\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)production));
        IdeTeamBo teamBo = production.getIdeTeam();
        IdeTeam ideTeam = null;
        if (teamBo != null) {
            ideTeam = this.ideTeamRepo.findOne(teamBo.getId());
            if (ideTeam == null) {
                ideTeam = new IdeTeam();
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                ideTeam.setId(Long.parseLong(teamBo.getId()));
                LOGGER.info("ideTeam==null \u6ca1\u627e\u5230\u65b0\u5efateam\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.save(ideTeam);
            } else {
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                LOGGER.info("\u627e\u5230team,\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.update(ideTeam);
            }
        }
        if ((ideApp = this.ideAppRepo.findById((appBo = production.getIdeApp()).getId())) != null) {
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp);
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u627e\u5230ideApp\uff0c\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.update(ideApp);
        } else {
            ideApp = new IdeApp();
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp, (String[])new String[]{"modifyDate"});
            ideApp.setId(Long.parseLong(appBo.getId()));
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u6ca1\u627e\u5230ideApp\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.save(ideApp);
        }
        List<IdeModuleBo> moduleBos = production.getIdeModules();
        ArrayList<IdeModule> updatedPages = new ArrayList<IdeModule>();
        LOGGER.info("\u63a5\u6536\u5230\u9875\u9762\uff1a" + JSONObject.toJSONString(moduleBos));
        ArrayList<String> failPages = new ArrayList<String>();
        if (moduleBos != null && moduleBos.size() > 0) {
            for (IdeModuleBo moduleBo : moduleBos) {
                try {
                    IdeModule ideModule = this.ideModuleRepo.findById(moduleBo.getId());
                    if (ideModule == null || ideModule.getId() == null) {
                        ideModule = new IdeModule();
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setId(Long.parseLong(moduleBo.getId()));
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c:\u6ca1\u627e\u5230\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.save(ideModule);
                    } else {
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c\u627e\u5230\u4e86:\u66f4\u65b0" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.update(ideModule);
                        LOGGER.info("\u5220\u9664\u53d1\u5e03\u9875\u9762\u7f13\u5b58\uff1apageCode" + moduleBo.getCode() + " AppCode\uff1a" + moduleBo.getAppCode());
                        LOGGER.info("\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01\u53d1\u5e03\u9875\u9762{}---{}---{}", new Object[]{moduleBo.getAppCode(), moduleBo.getCode(), null});
                        this.ideModulePageCache.removeModulePageCache(moduleBo.getAppCode(), moduleBo.getCode(), null);
                        ideModule.setAppCode(ideApp.getCode());
                        updatedPages.add(ideModule);
                    }
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....");
                    this.publishHistory(ideModule, production.getFromName(), production.getToName());
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....\u6210\u529f,\u5373\u5c06\u8d77\u52a8\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\uff0c\u5904\u7406\u9875\u9762\u65b0\u589e\u8282\u70b9\u95ee\u9898.......");
                    this.updatePrivatePage(updatedPages);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage() + "  \u9875\u9762\uff1a[" + moduleBo.getCode() + "]" + moduleBo.getName());
                    failPages.add("[" + moduleBo.getCode() + "]" + moduleBo.getName());
                }
            }
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f", failPages);
    }

    @Override
    public void updatePrivatePage(List<IdeModule> pages) {
        Thread runnable = new Thread(() -> {
            LOGGER.info("\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u542f\u52a8.....");
            for (IdeModule page : pages) {
                List<IdeModulePrivate> privates = this.ideModulePrivateService.findByPageCodeAndAppCode(page.getCode(), page.getAppCode());
                if (ListUtil.isNotEmpty(privates)) {
                    JSONObject baseData = JSONObject.parseObject((String)page.getData().replace("\\", ""));
                    for (IdeModulePrivate aPrivate : privates) {
                        JSONObject provData = JSONObject.parseObject((String)aPrivate.getData().replace("\\", ""));
                        JSONArray baseChildren = baseData.getJSONArray("children");
                        JSONArray provChildren = provData.getJSONArray("children");
                        IdeModuleServiceImpl.processChildren(baseChildren, provChildren);
                        aPrivate.setData(provData.toJSONString());
                        this.ideModulePrivateService.saveData(aPrivate);
                        LOGGER.info("\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01\u79c1\u6709\u5316\u9875\u9762{}---{}---{}", new Object[]{aPrivate.getAppCode(), aPrivate.getCode(), aPrivate.getOrgId()});
                        this.ideModulePageCache.removeModulePageCache(aPrivate.getAppCode(), aPrivate.getCode(), aPrivate.getOrgId() + "");
                    }
                    continue;
                }
                LOGGER.info("\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u6ca1\u6709\u79c1\u6709\u5316\u9875\u9762---{}---{}", (Object)page.getAppCode(), (Object)page.getCode());
            }
            LOGGER.info(".....\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u6267\u884c\u5b8c\u6bd5\uff01");
        });
        runnable.start();
    }

    private static void processChildren(JSONArray baseChildren, JSONArray provChildren) {
        if (baseChildren != null && baseChildren.size() > 0) {
            for (Object child : baseChildren) {
                JSONObject base = (JSONObject)child;
                JSONObject provP = null;
                boolean exist = false;
                for (Object provChild : provChildren) {
                    JSONObject prov = (JSONObject)provChild;
                    if (!Objects.equals(prov.getString("nid"), base.getString("nid"))) continue;
                    exist = true;
                    provP = prov;
                }
                if (exist) {
                    if (!Objects.equals(base.getString("uitype"), provP.getString("uitype")) || !Objects.equals(base.getString("uisubtype"), provP.getString("uisubtype"))) {
                        provChildren.remove(provP);
                        base.put("uititle", (Object)provP.getString("uititle"));
                        base.put("label", (Object)provP.getString("label"));
                        provChildren.add((Object)base);
                        continue;
                    }
                    Object baseObj = base.get((Object)"children");
                    if (!(baseObj instanceof JSONArray)) continue;
                    JSONArray baseChild = base.getJSONArray("children");
                    JSONArray provChild = provP.getJSONArray("children");
                    if (baseChild != null && baseChild.size() > 0 && (provChild == null || provChild.size() == 0)) {
                        provP.put("children", (Object)baseChild);
                        continue;
                    }
                    IdeModuleServiceImpl.processChildren(baseChild, provChild);
                    continue;
                }
                provChildren.add((Object)base);
            }
        }
    }

    public static void main(String[] args) {
        String jsonBase = "{\"children\":[{\"children\":[{\"visible\":false,\"children\":[],\"nid\":\"nid_1602197149128515600\",\"uikey\":\"EJCLayoutPanel1\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"top\",\"uititle\":\"\u5934\u90e8\",\"height\":\"0px\"},{\"visible\":true,\"children\":[{\"backgroundColor\":\"#F5F5F5\",\"color\":\"#999999\",\"children\":[{\"visible\":true,\"children\":[{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149619249156\",\"uikey\":\"K1670827653423\",\"uitype\":\"EJCPicker\",\"label\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"dismissText\":\"\u53d6\u6d88\",\"type\":\"1\",\"required\":true,\"field\":\"K1670827653423\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149619249157\",\"uikey\":\"K1670828292783\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828292783\",\"uititle\":\"\u662f\"},{\"children\":[],\"nid\":\"nid_1602197149619249158\",\"uikey\":\"K1670828303968\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828303968\",\"uititle\":\"\u5426\"}],\"extra\":\"\u8bf7\u9009\u62e9\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"\u786e\u5b9a\",\"cols\":1,\"uititle\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\"},{\"visible\":true,\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"id\":\"320519315475660894\",\"refCode\":\"market-project-refer-list\"},\"nid\":\"nid_1602197149652803586\",\"uikey\":\"K1670827654445\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654445\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u9879\u76ee\u540d\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_org_tree\",\"name\":\"\u7ec4\u7ec7\",\"id\":\"310428626500755491\",\"refCode\":\"idm_org_tree\"},\"nid\":\"nid_1602197149682163714\",\"uikey\":\"K1670827654959\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":true,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654959\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u6240\u5c5e\u7ec4\u7ec7\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_dept_list\",\"name\":\"\u90e8\u95e8\u5217\u8868\",\"id\":\"322468364965642298\",\"refCode\":\"idm_dept_list\"},\"nid\":\"nid_1602197149711523843\",\"uikey\":\"K1670827657878\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827657878\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u6240\u5c5e\u90e8\u95e8\"},{\"mode\":\"date\",\"field\":\"K1670827658392\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"\u8bf7\u9009\u62e9\u7533\u8bf7\u65e5\u671f\",\"nid\":\"nid_1602197149740883971\",\"uikey\":\"K1670827658392\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"\u7533\u8bf7\u65e5\u671f\",\"uititle\":\"\u7533\u8bf7\u65e5\u671f\",\"required\":false},{\"mode\":\"date\",\"field\":\"K1670827659736\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"\u8bf7\u9009\u62e9\u4f7f\u7528\u65e5\u671f\",\"nid\":\"nid_1602197149774438403\",\"uikey\":\"K1670827659736\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"\u4f7f\u7528\u65e5\u671f\",\"uititle\":\"\u4f7f\u7528\u65e5\u671f\",\"required\":true},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149803798531\",\"clear\":true,\"uikey\":\"K1670827660595\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827660595\",\"children\":[],\"placeholder\":\"\u8bf7\u8f93\u5165\u7533\u8bf7\u4eba\",\"decimal\":2,\"uititle\":\"\u7533\u8bf7\u4eba\"},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149833158658\",\"clear\":true,\"uikey\":\"K1670827661691\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827661691\",\"children\":[],\"placeholder\":\"\u8bf7\u8f93\u5165\u91d1\u989d\",\"decimal\":2,\"uititle\":\"\u91d1\u989d\"},{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149858324482\",\"uikey\":\"K1670827662739\",\"uitype\":\"EJCPicker\",\"label\":\"\u7533\u8bf7\u7c7b\u522b\",\"dismissText\":\"\u53d6\u6d88\",\"type\":\"1\",\"required\":false,\"field\":\"K1670827662739\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149858324483\",\"uikey\":\"K1670828387061\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828387061\",\"uititle\":\"\u5e7f\u544a\u5236\u4f5c\"},{\"children\":[],\"nid\":\"nid_1602197149858324484\",\"uikey\":\"K1670828387705\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828387705\",\"uititle\":\"\u529e\u516c\u7528\u54c1\"},{\"children\":[],\"nid\":\"nid_1602197149858324485\",\"uikey\":\"K1670828388401\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828388401\",\"uititle\":\"\u4f4e\u503c\u6613\u8017\u54c1\"},{\"children\":[],\"nid\":\"nid_1602197149858324486\",\"uikey\":\"K1670828389221\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828389221\",\"uititle\":\"\u5de5\u7a0b\u7269\u54c1\"},{\"children\":[],\"nid\":\"nid_1602197149858324487\",\"uikey\":\"K1670828392580\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828392580\",\"uititle\":\"\u8f6f\u4ef6\u8bbe\u5907\"},{\"children\":[],\"nid\":\"nid_1602197149858324488\",\"uikey\":\"K1670828393276\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828393276\",\"uititle\":\"\u5176\u4ed6\"}],\"extra\":\"\u8bf7\u9009\u62e9\u7533\u8bf7\u7c7b\u522b\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"\u786e\u5b9a\",\"cols\":1,\"uititle\":\"\u7533\u8bf7\u7c7b\u522b\"},{\"visible\":true,\"nid\":\"nid_1602197149891878914\",\"count\":200,\"clear\":true,\"uikey\":\"K1670827663271\",\"labelNumber\":7,\"uitype\":\"EJCTextareaItem\",\"label\":\"\u7528\u9014\",\"rows\":5,\"required\":false,\"field\":\"K1670827663271\",\"children\":[],\"disabled\":false,\"placeholder\":\"\u8bf7\u8f93\u5165\u7528\u9014\",\"uititle\":\"\u7528\u9014\",\"direction\":\"inside\"}],\"dataType\":\"object\",\"nid\":\"nid_1602197149619249154\",\"uikey\":\"EJCFormDev1\",\"uitype\":\"EJCFormDev\",\"uititle\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\"}],\"nid\":\"nid_1602197149619249153\",\"uikey\":\"EJCPart1\",\"uitype\":\"EJCPart\",\"leftType\":\"1\",\"uititle\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\",\"partName\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\"},{\"children\":[],\"sourceType\":\"attachMgr\",\"billType\":{\"billName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"metadataName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"billCode\":\"CFS1670824902742\",\"id\":1602181883325767700},\"nid\":\"nid_1602197150609104897\",\"uikey\":\"attachMgr\",\"uitype\":\"EJCAttachFilePick\",\"source\":{\"code\":\"CFS1670824902742\",\"sourceType\":\"attachMgr\",\"billType\":\"CFS1670824902742\",\"name\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"id\":1602181883325767700},\"uititle\":\"\u9644\u4ef6\u7ba1\u7406\",\"partName\":\"\u9644\u4ef6\u7ba1\u7406\"}],\"nid\":\"nid_1602197149128515601\",\"uikey\":\"EJCLayoutPanel2\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"center\",\"uititle\":\"\u4e2d\u90e8\",\"height\":\"calc(100% - 45px)\"},{\"visible\":true,\"children\":[{\"children\":[{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515604\",\"uikey\":\"removeBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"warning\",\"uititle\":\"\u5220\u9664\"},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515605\",\"uikey\":\"saveBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"ghost\",\"uititle\":\"\u4fdd\u5b58\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515606\",\"uikey\":\"callBackBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"uititle\":\"\u6536\u56de\"},{\"orgField\":\"orgId\",\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515607\",\"uikey\":\"EJCApproveSubmitBtn\",\"uitype\":\"EJCApproveSubmitBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u63d0\u4ea4\",\"billTypeId\":{\"billName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"code\":\"CFS1670824902742\",\"name\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"metadataName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"billCode\":\"CFS1670824902742\"}},{\"children\": [],\"nid\": \"nid_1602197169128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"warning\",\"uikey\": \"EJCApproveRejectBtn\",\"uititle\": \"\u9a73\u56de\",\"uitype\": \"EJCApproveRejectBtn\",\"visible\": true},{\"children\": [],\"nid\": \"nid_1602197179128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"primary\",\"uikey\": \"EJCApproveAgreeBtn\",\"uititle\": \"\u540c\u610f\",\"uitype\": \"EJCApproveAgreeBtn\",\"visible\": true},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515608\",\"uikey\":\"EJCApproveHistoryBtn\",\"uitype\":\"EJCApproveHistoryBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u5ba1\u6279\u5386\u53f2\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515609\",\"uikey\":\"saveApproveEditBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u786e\u8ba4\u4fee\u6539\"}],\"nid\":\"nid_1602197149128515603\",\"uikey\":\"EJCButtonBar1\",\"uitype\":\"EJCButtonBar\",\"uititle\":\"\u5e95\u90e8\u6309\u94ae\u7ec4\"}],\"nid\":\"nid_1602197149128515602\",\"uikey\":\"EJCLayoutPanel3\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"bottom\",\"uititle\":\"\u5e95\u90e8\",\"height\":\"45px\"}],\"nid\":\"nid_1602197149128515599\",\"uikey\":\"EJCLayout1\",\"uitype\":\"EJCLayout\",\"uititle\":\"\u4e0a\u4e2d\u4e0b\u5e03\u5c40\"}],\"nid\":\"nid_1602197149128515598\",\"uikey\":\"CFS1670824902742card\",\"uitype\":\"EJCPage\",\"subCols\":{},\"cfsAppInfo\":{\"appCode\":\"CFS1670824902742\",\"appGroupId\":1602181721178169300,\"appIcon\":\"https://portal.17elian.com/ejc-file-web/attachment/filePreview?filePath=1564909352936882178/202212/1602181835419107330.jpg\",\"appName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"appState\":1,\"attachIds\":[],\"authFlag\":0,\"createTime\":1670824903000,\"createUserCode\":\"13923119641\",\"customField\":{},\"dr\":0,\"id\":1602181883325767700,\"publishState\":0,\"queryRange\":0,\"sequence\":1,\"syncEsFlag\":0,\"tenantId\":1564909352936882200,\"type\":\"1,2\",\"version\":1},\"uititle\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\u8be6\u60c5\"}";
        String jsonProv = "{\"children\":[{\"children\":[{\"visible\":false,\"children\":[],\"nid\":\"nid_1602197149128515600\",\"uikey\":\"EJCLayoutPanel1\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"top\",\"uititle\":\"\u79c1\u6709\",\"height\":\"5px\"},{\"visible\":true,\"children\":[{\"backgroundColor\":\"#F5F5F5\",\"color\":\"#999999\",\"children\":[{\"visible\":true,\"children\":[{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149619249156\",\"uikey\":\"K1670827653423\",\"uitype\":\"EJCPicker\",\"label\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"dismissText\":\"\u53d6\u6d88\",\"type\":\"1\",\"required\":true,\"field\":\"K1670827653423\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149619249158\",\"uikey\":\"K1670828303968\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828303968\",\"uititle\":\"\u5426\"}],\"extra\":\"\u8bf7\u9009\u62e9\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"\u786e\u5b9a\",\"cols\":1,\"uititle\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\"},{\"visible\":true,\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"id\":\"320519315475660894\",\"refCode\":\"market-project-refer-list\"},\"nid\":\"nid_1602197149652803586\",\"uikey\":\"K1670827654445\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654445\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u9879\u76ee\u540d\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_org_tree\",\"name\":\"\u7ec4\u7ec7\",\"id\":\"310428626500755491\",\"refCode\":\"idm_org_tree\"},\"nid\":\"nid_1602197149682163714\",\"uikey\":\"K1670827654959\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":true,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654959\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u6240\u5c5e\u7ec4\u7ec7\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_dept_list\",\"name\":\"\u90e8\u95e8\u5217\u8868\",\"id\":\"322468364965642298\",\"refCode\":\"idm_dept_list\"},\"nid\":\"nid_1602197149711523843\",\"uikey\":\"K1670827657878\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827657878\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"\u6240\u5c5e\u90e8\u95e8\"},{\"mode\":\"date\",\"field\":\"K1670827658392\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"\u8bf7\u9009\u62e9\u7533\u8bf7\u65e5\u671f\",\"nid\":\"nid_1602197149740883971\",\"uikey\":\"K1670827658392\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"\u7533\u8bf7\u65e5\u671f\",\"uititle\":\"\u7533\u8bf7\u65e5\u671f\",\"required\":false},{\"mode\":\"date\",\"field\":\"K1670827659736\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"\u8bf7\u9009\u62e9\u4f7f\u7528\u65e5\u671f\",\"nid\":\"nid_1602197149774438403\",\"uikey\":\"K1670827659736\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"\u4f7f\u7528\u65e5\u671f\",\"uititle\":\"\u4f7f\u7528\u65e5\u671f\",\"required\":true},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149803798531\",\"clear\":true,\"uikey\":\"K1670827660595\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827660595\",\"children\":[],\"placeholder\":\"\u8bf7\u8f93\u5165\u7533\u8bf7\u4eba\",\"decimal\":2,\"uititle\":\"\u7533\u8bf7\u4eba\"},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149833158658\",\"clear\":true,\"uikey\":\"K1670827661691\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827661691\",\"children\":[],\"placeholder\":\"\u8bf7\u8f93\u5165\u91d1\u989d\",\"decimal\":2,\"uititle\":\"\u91d1\u989d\"},{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149858324482\",\"uikey\":\"K1670827662739\",\"uitype\":\"EJCPicker\",\"label\":\"\u7533\u8bf7\u7c7b\u522b\",\"dismissText\":\"\u53d6\u6d88\",\"type\":\"1\",\"required\":false,\"field\":\"K1670827662739\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149858324485\",\"uikey\":\"K1670828388401\",\"uitype\":\"EJCPickerItem1\",\"value\":\"K1670828388401\",\"uititle\":\"\u4f4e\u503c\u6613\u8017\u54c1\"},{\"children\":[],\"nid\":\"nid_1602197149858324486\",\"uikey\":\"K1670828389221\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828389221\",\"uititle\":\"\u5de5\u7a0b\u7269\u54c1\"},{\"children\":[],\"nid\":\"nid_1602197149858324487\",\"uikey\":\"K1670828392580\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828392580\",\"uititle\":\"\u8f6f\u4ef6\u8bbe\u5907\"},{\"children\":[],\"nid\":\"nid_1602197149858324488\",\"uikey\":\"K1670828393276\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828393276\",\"uititle\":\"\u5176\u4ed6\"}],\"extra\":\"\u8bf7\u9009\u62e9\u7533\u8bf7\u7c7b\u522b\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"\u786e\u5b9a\",\"cols\":1,\"uititle\":\"\u7533\u8bf7\u7c7b\u522b\"},{\"visible\":true,\"nid\":\"nid_1602197149891878914\",\"count\":200,\"clear\":true,\"uikey\":\"K1670827663271\",\"labelNumber\":7,\"uitype\":\"EJCTextareaItem\",\"label\":\"\u7528\u9014\",\"rows\":5,\"required\":false,\"field\":\"K1670827663271\",\"children\":[],\"disabled\":false,\"placeholder\":\"\u8bf7\u8f93\u5165\u7528\u9014\",\"uititle\":\"\u7528\u9014\",\"direction\":\"inside\"}],\"dataType\":\"object\",\"nid\":\"nid_1602197149619249154\",\"uikey\":\"EJCFormDev1\",\"uitype\":\"EJCFormDev\",\"uititle\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\"}],\"nid\":\"nid_1602197149619249153\",\"uikey\":\"EJCPart1\",\"uitype\":\"EJCPart\",\"leftType\":\"1\",\"uititle\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\",\"partName\":\"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\"},{\"children\":[],\"sourceType\":\"attachMgr\",\"billType\":{\"billName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"metadataName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"billCode\":\"CFS1670824902742\",\"id\":1602181883325767700},\"nid\":\"nid_1602197150609104897\",\"uikey\":\"attachMgr\",\"uitype\":\"EJCAttachFilePick\",\"source\":{\"code\":\"CFS1670824902742\",\"sourceType\":\"attachMgr\",\"billType\":\"CFS1670824902742\",\"name\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"id\":1602181883325767700},\"uititle\":\"\u9644\u4ef6\u7ba1\u7406\",\"partName\":\"\u9644\u4ef6\u7ba1\u7406\"}],\"nid\":\"nid_1602197149128515601\",\"uikey\":\"EJCLayoutPanel2\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"center\",\"uititle\":\"\u4e2d\u90e8\",\"height\":\"calc(100% - 45px)\"},{\"visible\":true,\"children\":[{\"children\":[{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515604\",\"uikey\":\"removeBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"warning\",\"uititle\":\"\u5220\u9664\"},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515605\",\"uikey\":\"saveBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"ghost\",\"uititle\":\"\u4fdd\u5b58\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515606\",\"uikey\":\"callBackBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"uititle\":\"\u6536\u56de\"},{\"orgField\":\"orgId\",\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515607\",\"uikey\":\"EJCApproveSubmitBtn\",\"uitype\":\"EJCApproveSubmitBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u63d0\u4ea4\",\"billTypeId\":{\"billName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"code\":\"CFS1670824902742\",\"name\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"metadataName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"billCode\":\"CFS1670824902742\"}},{\"children\": [],\"nid\": \"nid_1602197169128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"warning\",\"uikey\": \"EJCApproveRejectBtn\",\"uititle\": \"\u9a73\u56de\",\"uitype\": \"EJCApproveRejectBtn\",\"visible\": true},{\"children\": [],\"nid\": \"nid_1602197179128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"primary\",\"uikey\": \"EJCApproveAgreeBtn\",\"uititle\": \"\u540c\u610f\",\"uitype\": \"EJCApproveAgreeBtn\",\"visible\": true},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515608\",\"uikey\":\"EJCApproveHistoryBtn\",\"uitype\":\"EJCApproveHistoryBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u5ba1\u6279\u5386\u53f2\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515609\",\"uikey\":\"saveApproveEditBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"\u786e\u8ba4\u4fee\u6539\"}],\"nid\":\"nid_1602197149128515603\",\"uikey\":\"EJCButtonBar1\",\"uitype\":\"EJCButtonBar\",\"uititle\":\"\u5e95\u90e8\u6309\u94ae\u7ec4\"}],\"nid\":\"nid_1602197149128515602\",\"uikey\":\"EJCLayoutPanel3\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"bottom\",\"uititle\":\"\u5e95\u90e8\",\"height\":\"45px\"}],\"nid\":\"nid_1602197149128515599\",\"uikey\":\"EJCLayout1\",\"uitype\":\"EJCLayout\",\"uititle\":\"\u4e0a\u4e2d\u4e0b\u5e03\u5c40\"}],\"nid\":\"nid_1602197149128515598\",\"uikey\":\"CFS1670824902742card\",\"uitype\":\"EJCPage\",\"subCols\":{},\"cfsAppInfo\":{\"appCode\":\"CFS1670824902742\",\"appGroupId\":1602181721178169300,\"appIcon\":\"https://portal.17elian.com/ejc-file-web/attachment/filePreview?filePath=1564909352936882178/202212/1602181835419107330.jpg\",\"appName\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\",\"appState\":1,\"attachIds\":[],\"authFlag\":0,\"createTime\":1670824903000,\"createUserCode\":\"13923119641\",\"customField\":{},\"dr\":0,\"id\":1602181883325767700,\"publishState\":0,\"queryRange\":0,\"sequence\":1,\"syncEsFlag\":0,\"tenantId\":1564909352936882200,\"type\":\"1,3\",\"version\":1},\"uititle\":\"\u7269\u8d44\u7533\u8d2d\u7533\u8bf7\u8be6\u9752\"}";
        JSONObject baseData = JSONObject.parseObject((String)jsonBase);
        JSONObject provData = JSONObject.parseObject((String)jsonProv);
        JSONArray baseChildren = baseData.getJSONArray("children");
        JSONArray provChildren = provData.getJSONArray("children");
        IdeModuleServiceImpl.processChildren(baseChildren, provChildren);
        System.out.println(provData);
    }

    @Override
    public Page<IdeModule> findModulesByAppId(String appId, String searchText, boolean isDelete, Pageable pageable) throws Exception {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        List<IdeModule> ideModules = this.ideModuleRepo.findModuleListByAppId(appId, searchText, isDelete, pageIndex, pageable.getPageSize());
        Long total = this.ideModuleRepo.findModuleCountByAppId(appId, searchText, isDelete);
        PageImpl page = new PageImpl(ideModules, pageable, total.longValue());
        return page;
    }

    @Override
    public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
        String moduleIds = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                moduleIds = moduleIds + id + ",";
            }
            moduleIds = moduleIds.substring(0, moduleIds.length() - 1);
            List<IdeModulePrivate> modulePrivates = this.ideModulePrivateRepo.findListByModuleIds(moduleIds);
            return modulePrivates;
        }
        return null;
    }

    @Override
    public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
        String idStr = "";
        for (String id : ids) {
            idStr = idStr + id + ",";
        }
        if (StringUtils.isNotEmpty(idStr)) {
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        if (isRemove) {
            this.ideModuleRepo.removeByIds(idStr);
            this.ideModulePrivateRepo.removeByModuleIds(idStr);
        } else {
            this.ideModuleRepo.deleteByIds(idStr);
            this.moduleDataRepo.deleteByModuleIds(idStr);
            this.ideModulePrivateRepo.deleteByModuleIds(idStr);
        }
    }

    @Override
    public void restoreByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.ideModuleRepo.recoverByIds(idStr);
            this.ideModulePrivateRepo.recoverByModuleIds(idStr);
        }
    }

    @Override
    public JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException, Exception {
        if (pageIds != null && pageIds.size() > 0) {
            String pageIdStr = "";
            for (String pageId : pageIds) {
                pageIdStr = pageIdStr + pageId + ",";
            }
            pageIdStr = pageIdStr.substring(0, pageIdStr.length() - 1);
            this.ideModuleRepo.movePagesByAppId(pageIdStr, appId);
        }
        return JsonBackData.toSuccess("\u8fc1\u79fb\u6210\u529f");
    }

    @Override
    public List<IdeModule> findByIds(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            String idStr = "";
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            return this.ideModuleRepo.findByIds(idStr);
        }
        return null;
    }
}

