/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.common.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static HttpResponse get(String url, List<NameValuePair> params) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpGet httpget = new HttpGet(url);
            String str = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params));
            httpget.setURI(new URI(httpget.getURI().toString() + "?" + str));
            HttpResponse httpresponse = httpClient.execute((HttpUriRequest)httpget);
            return httpresponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse postJSON(String url, String jsonString) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            URIBuilder builder = new URIBuilder(url);
            HttpPost httppost = new HttpPost(builder.build());
            StringEntity stringEntity = new StringEntity(jsonString, "UTF-8");
            stringEntity.setContentType("application/json");
            httppost.setEntity((HttpEntity)stringEntity);
            httppost.setHeader("Accept", "application/json");
            httppost.setHeader("Content-type", "application/json");
            HttpResponse httpresponse = httpClient.execute((HttpUriRequest)httppost);
            return httpresponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HttpResponse postForm(String url, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            URIBuilder builder = new URIBuilder(url);
            HttpPost httppost = new HttpPost(builder.build());
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, params.get(key)));
            }
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse httpresponse = httpClient.execute((HttpUriRequest)httppost);
            return httpresponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

