/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.controller.IdeTeamController;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.foundation.front.util.JsonBackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/ide/moduleGroup"})
@Controller
public class IdeModuleGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeModuleGroupService moduleGroupService;

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeModuleGroup moduleGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.save(moduleGroup));
            backData.setSuccess(true);
            backData.setBackMsg("\u4fdd\u5b58\u7ec4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"{ids}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable(value="ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            this.moduleGroupService.deleteByIds(ids);
            backData.setBackMsg("\u5220\u9664\u7ec4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u5220\u9664\u7ec4\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData get(@PathVariable(value="id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.findById(id));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"findByAppId/{appId}"}, method={RequestMethod.GET})
    public JsonBackData findByAppId(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.findByAppId(appId));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }
}

