/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.service.IdeTeamService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/ideTeamMgr"})
public class IdeTeamMgrController {
    @Autowired
    private IdeTeamService ideTeamService;

    @ResponseBody
    @RequestMapping(value={"showList"}, method={RequestMethod.POST})
    public JsonBackData showList(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        int pageNumber = (Integer)query.get("pageNumber");
        int pageSize = (Integer)query.get("pageSize");
        String searchText = (String)query.get("searchText");
        boolean isDelete = (Boolean)query.get("isDelete");
        int prodType = (Integer)query.get("prodType") != null ? (Integer)query.get("prodType") : 0;
        try {
            PageRequest pageable = null;
            pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
            back.setBackData(this.ideTeamService.findPage(searchText, prodType, isDelete, (Pageable)pageable));
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"showAllTeam"})
    public JsonBackData showAllTeam() {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideTeamService.findTeamByProdType(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        boolean isRemove = (Boolean)query.get("isRemove");
        try {
            this.ideTeamService.deleteByIds(ids, isRemove);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"restore"}, method={RequestMethod.POST})
    public JsonBackData restoreByIds(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        try {
            this.ideTeamService.recoverByIds(ids);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }
}

