/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentBO;
import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentWhiteListBO;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironment;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironmentWhiteList;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeEnvironmentRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEnvironmentWhiteListRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeEnvironmentServiceImpl
implements IdeEnvironmentService {
    @Autowired
    private IdeEnvironmentRepo ideEnvironmentRepo;
    @Autowired
    private IdeEnvironmentWhiteListRepo ideEnvironmentWhiteListRepo;
    @Autowired
    private IdeTeamRepo ideTeamRepo;

    @Override
    public Page<IdeEnvironmentBO> findAll(Pageable pageable) throws BusinessException, Exception {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        Integer pageSize = pageable.getPageSize();
        List<IdeEnvironment> contents = this.ideEnvironmentRepo.findList(pageIndex, pageSize);
        Long total = this.ideEnvironmentRepo.findCount();
        if (contents != null && contents.size() > 0) {
            ArrayList<IdeEnvironmentBO> list = new ArrayList<IdeEnvironmentBO>();
            HashMap map = new HashMap();
            ArrayList<IdeEnvironmentWhiteList> lists = null;
            IdeEnvironmentBO bo = null;
            String urlStr = "";
            for (IdeEnvironment ideEnvironment : contents) {
                bo = new IdeEnvironmentBO();
                urlStr = urlStr + ideEnvironment.getUrl() + ",";
                bo.setId(String.valueOf(ideEnvironment.getId()));
                bo.setName(ideEnvironment.getName());
                bo.setUrl(ideEnvironment.getUrl());
                bo.setEnableWhiteList(ideEnvironment.getEnableWhiteList());
                list.add(bo);
            }
            List<IdeEnvironmentWhiteList> whiteLists = this.ideEnvironmentWhiteListRepo.findByUrls(urlStr.substring(0, urlStr.length() - 1));
            if (whiteLists.size() > 0 && whiteLists != null) {
                for (IdeEnvironmentWhiteList whiteList : whiteLists) {
                    if (map.containsKey(whiteList.getUrl())) {
                        ((List)map.get(whiteList.getUrl())).add(whiteList);
                        continue;
                    }
                    lists = new ArrayList<IdeEnvironmentWhiteList>();
                    lists.add(whiteList);
                    map.put(whiteList.getUrl(), lists);
                }
            }
            for (IdeEnvironmentBO ideEnvironmentBO : list) {
                List environmentWhiteLists = (List)map.get(ideEnvironmentBO.getUrl());
                if (environmentWhiteLists != null) {
                    ideEnvironmentBO.setWhiteListNum(environmentWhiteLists.size());
                    continue;
                }
                ideEnvironmentBO.setWhiteListNum(0);
            }
            return new PageImpl(list, pageable, total.longValue());
        }
        return null;
    }

    @Override
    public void saveOrUpdate(IdeEnvironmentBO bo) throws BusinessException, Exception {
        block5: {
            IdeEnvironment environment;
            block4: {
                environment = new IdeEnvironment();
                if (!StringUtils.isEmpty((String)bo.getId())) break block4;
                IdeEnvironment ideEnvironment = this.ideEnvironmentRepo.findByUrl(bo.getUrl());
                if (ideEnvironment != null) {
                    throw new BusinessException("\u8be5url\u5df2\u5b58\u5728\uff01");
                }
                environment.setId(IdWorker.getId());
                environment.setEnableWhiteList(bo.getEnableWhiteList());
                environment.setName(bo.getName());
                environment.setUrl(bo.getUrl());
                this.ideEnvironmentRepo.save(environment);
                List<IdeEnvironmentWhiteListBO> listBOs = bo.getWhiteListBOs();
                if (listBOs == null || listBOs.size() <= 0) break block5;
                for (IdeEnvironmentWhiteListBO bo2 : listBOs) {
                    IdeEnvironmentWhiteList whiteList = new IdeEnvironmentWhiteList();
                    whiteList.setId(IdWorker.getId());
                    whiteList.setTeamId(bo2.getTeamId());
                    whiteList.setUrl(bo.getUrl());
                    this.ideEnvironmentWhiteListRepo.save(whiteList);
                }
                break block5;
            }
            this.ideEnvironmentWhiteListRepo.deleteByUrls(bo.getUrl());
            environment.setId(Long.parseLong(bo.getId()));
            environment.setEnableWhiteList(bo.getEnableWhiteList());
            environment.setName(bo.getName());
            environment.setUrl(bo.getUrl());
            this.ideEnvironmentRepo.update(environment);
            List<IdeEnvironmentWhiteListBO> listBOs = bo.getWhiteListBOs();
            if (listBOs != null && listBOs.size() > 0) {
                for (IdeEnvironmentWhiteListBO bo2 : listBOs) {
                    IdeEnvironmentWhiteList whiteList = new IdeEnvironmentWhiteList();
                    whiteList.setId(IdWorker.getId());
                    whiteList.setTeamId(bo2.getTeamId());
                    whiteList.setUrl(bo.getUrl());
                    this.ideEnvironmentWhiteListRepo.save(whiteList);
                }
            }
        }
    }

    @Override
    public void deleteByUrls(String[] urls) throws BusinessException, Exception {
        String urlStr = "";
        if (urls != null && urls.length > 0) {
            for (String url : urls) {
                urlStr = urlStr + url + ",";
            }
            urlStr = urlStr.substring(0, urlStr.length() - 1);
            this.ideEnvironmentRepo.deleteByUrls(urlStr);
            this.ideEnvironmentWhiteListRepo.deleteByUrls(urlStr);
        }
    }

    @Override
    public IdeEnvironmentBO findByUrl(String url, int proType) throws BusinessException, Exception {
        IdeEnvironment ideEnvironment = this.ideEnvironmentRepo.findByUrl(url);
        List<IdeTeam> allTeams = this.ideTeamRepo.findTeamByProdType(proType);
        IdeEnvironmentBO bo = new IdeEnvironmentBO();
        HashMap<String, IdeTeam> map = new HashMap<String, IdeTeam>();
        for (IdeTeam ideTeam : allTeams) {
            map.put(String.valueOf(ideTeam.getId()), ideTeam);
        }
        List<IdeEnvironmentWhiteList> whiteLists = this.ideEnvironmentWhiteListRepo.findByUrls(url);
        if (ideEnvironment != null) {
            ArrayList<IdeEnvironmentWhiteListBO> whiteListbos = new ArrayList<IdeEnvironmentWhiteListBO>();
            IdeEnvironmentWhiteListBO whiteListBO = null;
            bo.setId(String.valueOf(ideEnvironment.getId()));
            bo.setName(ideEnvironment.getName());
            bo.setUrl(ideEnvironment.getUrl());
            bo.setEnableWhiteList(ideEnvironment.getEnableWhiteList());
            bo.setWhiteListNum(whiteLists.size());
            if (whiteLists != null && whiteLists.size() > 0) {
                for (IdeEnvironmentWhiteList whiteList : whiteLists) {
                    whiteListBO = new IdeEnvironmentWhiteListBO();
                    whiteListBO.setId(String.valueOf(whiteList.getId()));
                    whiteListBO.setTeamId(whiteList.getTeamId());
                    whiteListBO.setUrl(whiteListBO.getUrl());
                    IdeTeam ideTeam = (IdeTeam)map.get(whiteList.getTeamId());
                    if (ideTeam != null) {
                        whiteListBO.setTeamCode(ideTeam.getCode());
                        whiteListBO.setTeamName(ideTeam.getName());
                        map.remove(whiteList.getTeamId());
                    }
                    whiteListbos.add(whiteListBO);
                }
                bo.setWhiteListBOs(whiteListbos);
            }
        }
        ArrayList<IdeTeam> leftTeam = new ArrayList<IdeTeam>(map.values());
        bo.setLeftTeams(leftTeam);
        return bo;
    }

    @Override
    public boolean isInWhiteList(String url, String teamId) {
        IdeEnvironmentWhiteList ideEnvironmentWhiteList;
        IdeEnvironment ideEnvironment = this.ideEnvironmentRepo.findByUrl(url);
        return ideEnvironment == null || ideEnvironment.getEnableWhiteList() != 1 || (ideEnvironmentWhiteList = this.ideEnvironmentWhiteListRepo.findByUrlAndTeam(url, teamId)) != null;
    }

    @Override
    public List<IdeEnvironment> findAllUrls() {
        return this.ideEnvironmentRepo.findAllUrls();
    }

    @Override
    public IdeEnvironment findById(String id) {
        return this.ideEnvironmentRepo.findOne(id);
    }
}

