package com.ejianc.foundation.front.business.ide.controller;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 页面管理服务
 */
@RestController
@RequestMapping(value = "/ide/module")
public class IdeModuleController implements Constant{
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleController.class);
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeModulePageCache ideModulePageCache;
	@Autowired
	IdeModulePrivateService ideModulePrivateService;

    /**
     * 通过应用编码获取应用信息
     * @param code
     * @return
     */
    @RequestMapping(value="findcode",method = RequestMethod.GET)
    public JsonBackData findByCode(String code) {
    	JsonBackData backData = new JsonBackData();
    	try {
    		IdeModule ideModule = ideModuleService.findByCode(code);
    		backData.setBackData(ideModule);
    		backData.setBackMsg("成功");
    	} catch (Exception e) {
    		e.printStackTrace();
    		backData.setBackMsg("系统错误");
    		backData.setSuccess(false);
    	}
    	return backData;
    }

	public static void main(String[] args) {
		String cfs = "CFS1636967890151list";
		System.out.println(cfs.substring(0,cfs.length()-4));
	}
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeModule ideModule) throws BusinessException, Exception {
        try {
        	IdeModule module = ideModuleService.saveOrUpdate(ideModule);
			IdeModuleBo bo = ideModuleService.findById(module.getId()+"");
			LOGGER.info("IdeModuleController92行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
			if(StringUtils.isNotEmpty(bo.getCode()) && bo.getCode().startsWith("CFS")){
				if(bo.getCode().endsWith("card") || bo.getCode().endsWith("list")){
					ideModulePageCache.removeModulePageCache(bo.getCode().substring(0,bo.getCode().length()-4),bo.getCode(),null);
				}else {
					LOGGER.info("IdeModuleController97行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
					ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode(),null);
					ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode()+"list",null);
					ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode()+"card",null);
				}
			}else {
				LOGGER.info("IdeModuleController98行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
				ideModulePageCache.removeModulePageCache(bo.getAppCode(),bo.getCode(),null);
			}
			/** 测试环境测试使用  */
			List<IdeModule> pages = new ArrayList<>();
			module.setAppCode(bo.getAppCode());
			pages.add(module);
//			ideModuleService.updatePrivatePage(pages);
			/** 测试环境测试使用  */

            return JsonBackData.toSuccess("保存成功",module);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }

    }

    @RequestMapping(value = "{id}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable String id) throws Exception {
        try {
			IdeModuleBo module = ideModuleService.findById(id);
            ideModuleService.deleteById(id);
			LOGGER.info("从缓存删除页面数据！delete {}---{}---{}",module.getAppCode(), module.getCode(),null);
            ideModulePageCache.removeModulePageCache(module.getAppCode(),module.getCode(),null);
            return JsonBackData.toSuccess("删除成功");            
        } catch (Exception e) {
            e.printStackTrace();            
            return JsonBackData.toError(e.getMessage());
        }

    }

    @RequestMapping(value="{id}",method = RequestMethod.GET)
    public JsonBackData module(@PathVariable String id) {
        try {
            IdeModuleBo ideModuleBo = ideModuleService.findById(id);
            return JsonBackData.toSuccess("",ideModuleBo);            
        } catch (Exception e) {
            e.printStackTrace();
        	return JsonBackData.toError(e.getMessage());
        }
    }

    /**
     * 查询页面增加redis缓存------2023-01-14
     * 
     * @param appCode
     * @param pageCode
     * @param mode
     * @param orgId
     * @param tenantId
     * @param request
     * @return
     */
    @RequestMapping(value="findByAppCodeAndPageCode",method = RequestMethod.GET)
    public JsonBackData findByAppCodeAndPageCode(String appCode,String pageCode,
												 String mode,
												 @RequestParam(name="orgId",required=false) String orgId,
												 @RequestParam(name="tenantId",required=false) String tenantId,
												 HttpServletRequest request
	) {
		String authority = request.getHeader(ReferConstant.HEAD_authority);
		String locale = null;//语言选择
		if(StringUtils.isNotBlank(authority)) {
			//从authority获取多语参数
			String[] ac = authority.split(";");
			for (String s : ac) {
				String[] cookieArr = s.split("=");
				if("u_locale".equals(cookieArr[0])) {
					locale = cookieArr[1];
					break;
				}
			}
		}
        try {
			/** 先读取私有化页面 */
        	Object ideModule = null;
        	if(orgId!=null){
				ideModule =ideModulePageCache.getProvidePageCache(appCode, pageCode, orgId);
				if(ideModule == null) {
					ideModule = ideModulePrivateService.findByOrgId(pageCode, appCode, orgId,tenantId);
					if(ideModule != null){
						LOGGER.info("数据库读取到私有化页面，向缓存写入页面数据！{}---{}---{}",appCode, pageCode, orgId);
						/** 私有化页面 */
						ideModulePageCache.putModulePageCache(appCode, pageCode, orgId, ideModule);
						return JsonBackData.toSuccess("查询成功！", ideModule);
					}
				}else {
					LOGGER.info("从缓存读取到私有化页面数据！{}---{}---{}",appCode, pageCode, orgId);
					return JsonBackData.toSuccess("查询成功！", ideModule);
				}
			}
			/** 读取公共页面 */
			ideModule = ideModulePageCache.getModulePageCache(appCode, pageCode);
			if(ideModule == null) {
        		if(StringUtils.isNotEmpty(pageCode) && pageCode.startsWith("CFS")){
        			ideModule = ideModuleService.findByCode(pageCode);
        		}else {
					ideModule = ideModuleService.findByAppCodeAndModuleCodeAndOrgId(appCode,pageCode,orgId,tenantId);
        		}
				if(ideModule != null && StringUtils.isNotEmpty(locale) && locale.equals("en")){
					IdeModule pro = (IdeModule)ideModule;
					if(StringUtils.isNotEmpty(pro.getEnData())){
						pro.setData(pro.getEnData());
						pro.setEnData(null);
					}
					ideModule = pro;
				}
				if(ideModule != null) {
					LOGGER.info("数据库读取到公共页面，向缓存写入页面数据！ {}---{}---{}",appCode, pageCode, orgId);
					ideModulePageCache.putModulePageCache(appCode, pageCode, null, ideModule);
					return JsonBackData.toSuccess("查询成功！", ideModule);
				}
        	}else {
        		LOGGER.info("从缓存读取公共页面数据！{}---{}---{}",appCode, pageCode, orgId);
				return JsonBackData.toSuccess("查询成功！", ideModule);
			}
			return JsonBackData.toError("页面尚未发布！");
        } catch (Exception e) {
            e.printStackTrace();
			LOGGER.error("出错啦！"+e.getMessage()+e.getLocalizedMessage(),e);
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value="copy",method = RequestMethod.POST)
    public JsonBackData copy(@RequestBody IdeModule ideModule) {
        try {
            ideModuleService.copyModule(ideModule);
            return JsonBackData.toSuccess();
        } catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
    
    /**
     * 备份设计页面json数据
     * @param moduleId
     * @param filename
     * @param response
     */
    @RequestMapping(value = "backup/{moduleId}", method = RequestMethod.GET)
	public void backup(@PathVariable("moduleId") String moduleId, String filename, HttpServletResponse response) {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
	    response.setHeader("Content-Disposition", "attachment; filename=\""+ filename +".txt\"");
	    try {
	        OutputStream outputStream = response.getOutputStream();
	        // 获取页面json数据
	        String data = ideModuleService.findById(moduleId).getData();
	        outputStream.write(data.getBytes());
	        outputStream.flush();
	        outputStream.close();
	    } catch (BusinessException e) {
	    	e.printStackTrace();
	    } catch(Exception e) {
	    	e.printStackTrace();
	    }
	}
    
    /**
     * 导入的json数据直接更新保存到对应页面配置信息
     */
    @Deprecated
    @RequestMapping(value="restore",method=RequestMethod.POST)
    public JsonBackData restore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
    	try {
    		// 上传的数据转成string
        	ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			// 验证
			IdeModule ideModule = ideModuleService.findEntityById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModule.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData!=null && oldData.get("uitype").equals(newData.get("uitype")); 
			if(valide || oldData==null){
				// 保存data
				ideModule.setModifyDate(new Date());
				ideModule.setData(myString);
				ideModuleService.saveOrUpdate(ideModule);
				return JsonBackData.toSuccess();

			} else {
				return JsonBackData.toError("页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError(e.getMessage());
		}
    }
    /**
     * 将导入的json数据直接返回到前端
     */
    @RequestMapping(value="getrestore",method=RequestMethod.POST)
    public JsonBackData getRestore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
    	try {
    		// 上传的数据转成string
        	ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			IdeModule ideModule = ideModuleService.findEntityById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModule.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData!=null && oldData.get("uitype").equals(newData.get("uitype")); 
			if(valide || oldData==null){
				return JsonBackData.toSuccessData(myString);
			} else {
				return JsonBackData.toError("导入失败：页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError("导入异常："+e.getMessage());
		}
    }
    /**
     * 发布页面（同步数据到目标环境的数据库）
	 * 移动设计器 发布
     * @return
     */
    @ResponseBody
    @RequestMapping(value="syncpublish",method = RequestMethod.POST)
    public JsonBackData syncPages(String appId, @RequestParam("pageIds") List<String> pageIds,String fromName,String toName) {
    	try{
	    	JsonBackData backData = ideModuleService.syncPublishProduction(appId, pageIds, fromName, toName);
	    	return backData;
    	}catch(Exception e){
    		return JsonBackData.toError(e.getMessage());
    	}
    }
    
    @ResponseBody
    @RequestMapping(value="move",method = RequestMethod.POST)
    public JsonBackData movePage(String appId, String[] pageIds) {
    		List<String> pageIdList = Arrays.asList(pageIds);
    		try{
    			JsonBackData jsonBackData = ideModuleService.movePage(pageIdList, appId);
    			return jsonBackData;
    		} catch(Exception e) {
    			e.printStackTrace();
        		return JsonBackData.toError(e.getMessage());
    		}
    }


    /** 实施快速发布页面数据
	 * @return*/
	@ResponseBody
	@RequestMapping(value="publishFast",method = RequestMethod.GET)
	public CommonResponse publishFast(@RequestParam("pageId") String pageId, @RequestParam("baseUrl") String baseUrl){
	 	LOGGER.info("实施快速发布页面数据,pageId = {}  ---baseUrl = {}",pageId,baseUrl);
		IdeModule module = ideModuleService.findEntityById(pageId);
		if(module == null){
			return CommonResponse.error("页面不存在");
		}
		HttpResponse httpresponse = HttpClientUtil.postJSON(baseUrl + Constant.PUBLISH_FAST_URL+pageId, module.getData());
		if (httpresponse == null) {
			return CommonResponse.error("发布失败，目标服务器响应异常");
		}
		// 获取状态码
		int resCode = httpresponse.getStatusLine().getStatusCode();
		// 请求失败
		if (resCode != 200) {
			return CommonResponse.error("发布失败，目标服务器异常，响应状态码：" + resCode);
		}
		try {
			String result = EntityUtils.toString(httpresponse.getEntity());
			return JSONObject.parseObject(result,CommonResponse.class);
		} catch (IOException e) {
			e.printStackTrace();
			return CommonResponse.error("发布失败，目标服务器响应异常数据！");
		}
	}

	/** 接收数据 */
	@ResponseBody
	@RequestMapping(value="receiveFast/{moduleId}",method = RequestMethod.POST)
	public CommonResponse<String> receiveFast(@PathVariable("moduleId") String moduleId,@RequestBody String data){
		LOGGER.info("实施快速发布页面,接收数据,pageId = {}  ---data = {}",moduleId,data);
		IdeModule module = ideModuleService.findEntityById(moduleId);
		if(module == null){
			return CommonResponse.error("目标服务器页面不存在");
		}
		module.setData(data);
		try {
			ideModuleService.saveOrUpdate(module);
		} catch (Exception e) {
			e.printStackTrace();
			return CommonResponse.error("发布失败！目标服务器保存数据失败！");
		}
		return CommonResponse.success("发布成功！");
	}
}