package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeTeamUser;

@Mapper
public interface IdeTeamUserRepo {

    /**
     * 查找团队-用户关联实体
     *
     * @param teamId 团队id
     * @param userId 用户id
     * @return 团队-用户关联实体
     */
    IdeTeamUser findByTeamIdAndUserId(@Param("teamId") String teamId,@Param("userId") String userId);

    /**
     * 删除团队-用户关联（逻辑删除）
     *
     * @param teamId 团队id
     */
    void deleteByTeamId(@Param("teamId") String teamId);

    /**
     * 删除团队-用户关联
     *
     * @param teamId 团队id
     * @param userIds 用户id数组
     */
    void deleteUsers(@Param("teamId") String teamId, @Param("userIds") String userIds);

    /**
     * 查找团队下用户实际个数
     *
     * @param teamId 团队id
     */
    int countUsers(@Param("teamId") String teamId);

    /**
     * 获取团队用户
     *
     * @param teamId 团队id
     * @param userId 用户id
     * @return 团队-用户关联实体
     */
    IdeTeamUser getTeamUser(@Param("teamId") String teamId, @Param("userId") String userId);

    /**
     * 获取团队创建者
     *
     * @param teamId 团队id
     * @return 团队-用户关联实体
     */
    IdeTeamUser getTeamCreator(@Param("teamId") String teamId);

    /**
     * 获取团队用户
     *
     * @param teamId 团队id
     * @param userIds 用户id数组
     * @return 团队-用户关联实体列表
     */
    List<IdeTeamUser> getTeamUsers(@Param("teamId") String teamId, @Param("userIds") String userIds);
    
    /**
     * 逻辑删除团队-用户关联
     *
     * @param teamId 团队id
     * @param userIds 用户id数组
     */
    void deleteUsersByTeamId(@Param("teamId") String teamId, @Param("userIds") String userIds);
    /**
     * 删除团队-用户关联
     *
     * @param teamId 团队id
     * @param userIds 用户id数组
     */
    void recoverUsers(@Param("teamId") String teamId, @Param("userIds") String userIds);
    
    void deleteUsersByTeamIds(@Param("teamIds") String teamIds);

	void save(IdeTeamUser teamUser);

	void update(IdeTeamUser teamUser);
}
