package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAjustTemplateService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@Service
@Transactional
public class IdeAjustTemplateServiceImpl implements IdeAjustTemplateService{
	private static final String CPCARDPAGE = "CPCardPage";
	private static final String CPLISTPAGE = "CPListPage";
	private static final String UI_KEY = "uikey";
    private static final String UI_TITLE = "uititle";
    private static final String UI_TYPE = "uitype";
    private static final String CHILDREN = "children";
    
    private String billType; 
    private String billName;
    private JSONObject YYSearchCondition;
	@Autowired
    private IdeModuleRepo moduleRepo;
	
	@Override
	public JsonBackData adjustTemplate(String[] moduleIds) throws BusinessException, Exception {
		// 记录转换失败的页面
		List<String> failPages = new ArrayList<String>();
		if(moduleIds.length > 0){
			String moduleIdStr = "";
			for(String moduleId:moduleIds) {
				moduleIdStr += moduleId + ",";
			}
			List<IdeModule> modules = moduleRepo.findByIds(moduleIdStr.substring(0, moduleIdStr.length()-1));
			if (modules != null&&modules.size() > 0) {
				//定义顶部区域json
				for (IdeModule ideModule : modules) {
					try {
						if(ideModule.getPageType().equals(CPCARDPAGE)){
							JSONObject jsonData = JSONObject.parseObject(ideModule.getData());
							jsonData = this.dealCardJSONObject(jsonData);
							String data = jsonData.toJSONString();
							ideModule.setData(data);
							ideModule.setPageType("cardPage");
							moduleRepo.update(ideModule);
								
						}else if(ideModule.getPageType().equals(CPLISTPAGE)){
							JSONObject jsonData = JSONObject.parseObject(ideModule.getData());
							jsonData = this.dealListJSONObject(jsonData);
							String data = jsonData.toJSONString();
							ideModule.setData(data);
							ideModule.setPageType("listPage");
							moduleRepo.update(ideModule);
						}
					} catch (Exception e) {
						failPages.add("["+ideModule.getCode()+"]"+ideModule.getName());
					}
				}
			}else {
				throw new BusinessException("找不到对应的页面");
			}
		}
		return JsonBackData.toSuccess("转换模板成功",failPages);
	}
	
	//卡片转换模板
	private JSONObject dealCardJSONObject(JSONObject jsonObject){
		if(jsonObject.get(UI_TYPE).equals("CPCardPage")){
			jsonObject.put(UI_TYPE, "YYPage");
		}
		if(jsonObject.get(UI_TYPE).equals("CPCardHeader")){
			jsonObject.put(UI_TYPE, "YYToolbar");
		}
		if(jsonObject.get(UI_TYPE).equals("YYAccordion")){
			jsonObject.put(UI_TYPE, "YYPanel");
		}
		if(jsonObject.get(UI_TYPE).equals("YYPanel")){
			jsonObject.remove("isOpen");
			jsonObject.remove("header");
			jsonObject.remove("enableStepTarget");
			jsonObject.put("expandText", "收起");
			jsonObject.put("collapseText", "展开");
			jsonObject.put("title", jsonObject.get(UI_TITLE));
		}
		if(jsonObject.get(UI_TYPE).equals("YYPage")||jsonObject.get(UI_TYPE).equals("YYCol")){
			if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
				JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
				for (int i = 0; i < jsonArray.size(); i++) {
					JSONObject jsonObjectChild = (JSONObject) jsonArray.get(i);
					if(jsonObjectChild.get(UI_TYPE).equals("CPCardBody") || jsonObjectChild.get(UI_TYPE).equals("YYAccordions")){
						if(jsonObjectChild.containsKey(CHILDREN) && jsonObjectChild.get(CHILDREN) instanceof JSONArray){
							JSONArray jsonArrayChild = jsonObjectChild.getJSONArray(CHILDREN);
							for (Object objectChild : jsonArrayChild) {
								jsonArray.add(objectChild);
							}
						}
						jsonArray.remove(i);
						break;
					}
				}
				jsonObject.put(CHILDREN, jsonArray);
			}
		}
		if(jsonObject.get(UI_TYPE).equals("YYPage")){
			jsonObject.put("themeClassName", "GYY");
			if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
				JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
				String title = "单据标题";
				for (int i = 0; i < jsonArray.size(); i++) {
					JSONObject jsonObjectChild = (JSONObject) jsonArray.get(i);
					if(jsonObjectChild.get(UI_TYPE).equals("CPCardTitle")){
						title = (String) jsonObjectChild.get(UI_TITLE);
						jsonArray.remove(i);
						break;
					}
				}
				jsonArray.add(0,this.getCardAreaJson(title));
				jsonObject.put(CHILDREN, jsonArray);
			}
		}
		if(jsonObject.get(UI_TYPE).equals("YYToolbar")){
			if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
				JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
				for (int i = 0; i < jsonArray.size(); i++) {
					JSONObject jsonObjectChild = (JSONObject) jsonArray.get(i);
					if(jsonObjectChild.get(UI_TYPE).equals("CPGoBack")){
						jsonArray.remove(i);
						break;
					}
				}
				jsonObject.put(CHILDREN, jsonArray);
			}
		}
		if(jsonObject.get(UI_TYPE).equals("CPIconButton")){
			jsonObject.put(UI_TYPE, "YYButton");
		}
		if(jsonObject.get(UI_TYPE).equals("YYButton")){
			jsonObject.put("type", "error");
			jsonObject.put("ghost", true);
			jsonObject.put("children", jsonObject.get(UI_TITLE));
			jsonObject.remove("text");
			jsonObject.remove("color");
			jsonObject.remove("align");
		}
		if(jsonObject.get(UI_TYPE).equals("CPDropdownButton")){
			jsonObject.put(UI_TYPE, "YYButtonSelect");
		}
		if(jsonObject.get(UI_TYPE).equals("YYButtonSelect")){
			jsonObject.put("type", "error");
			jsonObject.put("buttonText", jsonObject.get(UI_TITLE));
			jsonObject.remove("text");
		}
		if(jsonObject.get(UI_TYPE).equals("CPDropdownItem")){
			jsonObject.put(UI_TYPE, "YYButtonItem");
			jsonObject.put("clickKey", jsonObject.get(UI_KEY));
			jsonObject.put("children", jsonObject.get(UI_TITLE));
		}
		if(jsonObject.get(UI_TYPE).equals("CPAttachMgr")){
			jsonObject.put(UI_TYPE, "AttachMgrWidget");
		}
		if(jsonObject.get(UI_TYPE).equals("CPBpmSubmit")){
			jsonObject.put(UI_TYPE, "BpmSubmitWidget");
		}
		if(jsonObject.get(UI_TYPE).equals("CPBpmApprove")){
			jsonObject.put(UI_TYPE, "BpmApproveWidget");
		}
		if(jsonObject.get(UI_TYPE).equals("CPPrintButton")){
			jsonObject.put(UI_TYPE, "YYPrintButton");
		}
		if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
			JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
			for (Object object : jsonArray) {
				if(object != null){
					object = this.dealCardJSONObject((JSONObject)object);
				}
			}
			jsonObject.put(CHILDREN, jsonArray);
		}
		return jsonObject;
	}

	//列表转换模板
	private JSONObject dealListJSONObject(JSONObject jsonObject){
		if(jsonObject.get(UI_TYPE).equals("CPListPage")){
			jsonObject.put(UI_TYPE, "YYPage");
		}
		if(jsonObject.get(UI_TYPE).equals("CPListToolbar")){
			jsonObject.put(UI_TYPE, "YYToolbar");
		}
		if(jsonObject.get(UI_TYPE).equals("YYPage")){
			jsonObject.put("themeClassName", "GYY");
			if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
				JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
				for (int i = 0; i < jsonArray.size(); i++) {
					JSONObject jsonObjectChild = (JSONObject) jsonArray.get(i);
					if(jsonObjectChild.get(UI_TYPE).equals("CPListHeader")){
						if(jsonObjectChild.containsKey(CHILDREN) && jsonObjectChild.get(CHILDREN) instanceof JSONArray){
							JSONArray jsonArrayChild = jsonObjectChild.getJSONArray(CHILDREN);
							for (Object objectChild : jsonArrayChild) {
								JSONObject jsonObjectChild2 = (JSONObject) objectChild;
								if(jsonObjectChild2.get(UI_TYPE).equals("YYSchemeGroup")){
									this.setBillType((String)jsonObjectChild2.get("billType"));
									this.setBillName((String)jsonObjectChild2.get("billName"));
								}
								if(jsonObjectChild2.get(UI_TYPE).equals("CPSearchBar")){
									jsonObjectChild2.put(UI_TYPE, "YYSearchCondition");
									this.setYYSearchCondition(jsonObjectChild2);
								}
							}
						}
						jsonArray.remove(i);
						break;
					}
				}
				jsonArray.add(0,this.getListAreaJson(this.getBillType(),this.getBillName()));
				jsonObject.put(CHILDREN, jsonArray);
			}
		}
		if(jsonObject.get(UI_TYPE).equals("YYToolbar")){
			if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
				JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
				jsonArray.add(this.getYYSearchCondition());
				jsonObject.put(CHILDREN, jsonArray);
			}
		}
		if(jsonObject.get(UI_TYPE).equals("CPListTable")){
			jsonObject.put(UI_TYPE, "TableWidget");
		}
		if(jsonObject.get(UI_TYPE).equals("CPIconButton")){
			jsonObject.put(UI_TYPE, "YYButton");
		}
		if(jsonObject.get(UI_TYPE).equals("YYButton")){
			jsonObject.put("type", "error");
			jsonObject.put("ghost", true);
			jsonObject.put("children", jsonObject.get(UI_TITLE));
			jsonObject.remove("text");
			jsonObject.remove("color");
			jsonObject.remove("align");
		}
		if(jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray){
			JSONArray jsonArray = jsonObject.getJSONArray(CHILDREN);
			for (Object object : jsonArray) {
				if(object != null){
					object = this.dealListJSONObject((JSONObject)object);
				}
			}
			jsonObject.put(CHILDREN, jsonArray);
		}
		return jsonObject;
	}
	
	private JSONObject getCardAreaJson(String title){
		String jsonStr =  "{\n" +
				"  \"uititle\": \"顶部区域\",\n" +
				"  \"uitype\": \"YYArea\",\n" +
				"  \"nid\": \"nid_1525861773853_2\",\n" +
				"  \"uikey\": \"cardTopBar\",\n" +
				"  \"children\": [\n" +
				"    {\n" +
				"      \"uititle\": \""+title+"\",\n" +
				"      \"uitype\": \"YYCaption\",\n" +
				"      \"nid\": \"nid_1525924478783_2\",\n" +
				"      \"children\": \""+title+"\",\n" +
				"      \"uikey\": \"cardTitle\"\n" +
				"    },\n" +
				"    {\n" +
				"      \"uititle\": \"面包屑\",\n" +
				"      \"uitype\": \"YYBreadcrumb\",\n" +
				"      \"nid\": \"nid_1481614719767_14\",\n" +
				"      \"children\": [\n" +
				"        {\n" +
				"          \"uitype\": \"YYBreadcrumbItem\",\n" +
				"          \"uititle\": \"首页\",\n" +
				"          \"key\": \"1481614729767_15\",\n" +
				"          \"uikey\": \"goHome\",\n" +
				"          \"title\": \"面包屑元素1\",\n" +
				"          \"children\": \"首页\",\n" +
				"          \"nid\": \"nid_1481614729767_16\"\n" +
				"        },\n" +
				"        {\n" +
				"          \"uitype\": \"YYBreadcrumbItem\",\n" +
				"          \"uititle\": \"xx台账\",\n" +
				"          \"key\": \"1525924550255_205\",\n" +
				"          \"uikey\": \"goList\",\n" +
				"          \"children\": \"xx台账\",\n" +
				"          \"nid\": \"nid_1525924550255_206\"\n" +
				"        },\n" +
				"        {\n" +
				"          \"uitype\": \"YYBreadcrumbItem\",\n" +
				"          \"uititle\": \"新增\",\n" +
				"          \"key\": \"1481614731199_17\",\n" +
				"          \"uikey\": \"opType\",\n" +
				"          \"title\": \"面包屑元素2\",\n" +
				"          \"children\": \"新增\",\n" +
				"          \"nid\": \"nid_1481614731199_18\"\n" +
				"        }\n" +
				"      ],\n" +
				"      \"uikey\": \"cardBreadcrumb\",\n" +
				"      \"separator\": \"/\"\n" +
				"    }\n" +
				"  ]\n" +
				"}";
		return JSONObject.parseObject(jsonStr);
	}

	private JSONObject getListAreaJson(String billType,String billName){
		String jsonStr =  "{\n" +
			    "  \"uititle\": \"顶部栏\",\n" +
			    "  \"uitype\": \"YYArea\",\n" +
			    "  \"nid\": \"nid_1526011032033_837\",\n" +
			    "  \"children\": [\n" +
			    "    {\n" +
			    "      \"uititle\": \"标题文本\",\n" +
			    "      \"uitype\": \"YYCaption\",\n" +
			    "      \"nid\": \"nid_1526011040921_840\",\n" +
			    "      \"children\": \"标题文本\",\n" +
			    "      \"uikey\": \"listTitle\"\n" +
			    "    },\n" +
			    "    {\n" +
			    "      \"nid\": \"nid_1526011053577_844\",\n" +
			    "      \"uikey\": \"listBreadcrumb\",\n" +
			    "      \"separator\": \"/\",\n" +
			    "      \"children\": [\n" +
			    "        {\n" +
			    "          \"uitype\": \"YYBreadcrumbItem\",\n" +
			    "          \"uititle\": \"首页\",\n" +
			    "          \"key\": \"1524537458375_450\",\n" +
			    "          \"uikey\": \"goHome\",\n" +
			    "          \"children\": \"首页\",\n" +
			    "          \"nid\": \"nid_1526011053577_841\"\n" +
			    "        },\n" +
			    "        {\n" +
			    "          \"uitype\": \"YYBreadcrumbItem\",\n" +
			    "          \"uititle\": \"XX列表\",\n" +
			    "          \"key\": \"1524537467633_562\",\n" +
			    "          \"uikey\": \"goList\",\n" +
			    "          \"children\": \"XX列表\",\n" +
			    "          \"nid\": \"nid_1526011053577_842\"\n" +
			    "        }\n" +
			    "      ],\n" +
			    "      \"uititle\": \"面包屑\",\n" +
			    "      \"uitype\": \"YYBreadcrumb\"\n" +
			    "    },\n" +
			    "    {\n" +
			    "      \"uititle\": \"方案栏\",\n" +
			    "      \"uitype\": \"YYSchemeGroup\",\n" +
			    "      \"nid\": \"nid_1526447764720_3\",\n" +
			    "      \"uikey\": \"schemeGroup\",\n" +
			    "      \"billName\": \""+billName+"\",\n" +
			    "      \"billType\": \""+billType+"\"\n" +
			    "    }\n" +
			    "  ],\n" +
			    "  \"uikey\": \"listTopBar\"\n" +
			    "}";
		return JSONObject.parseObject(jsonStr);
	}
	
	
	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public JSONObject getYYSearchCondition() {
		return YYSearchCondition;
	}

	public void setYYSearchCondition(JSONObject yYSearchCondition) {
		YYSearchCondition = yYSearchCondition;
	}
	
	

}
