package com.ejianc.foundation.front.business.ide.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * 组controller
 */
@ResponseBody
@RequestMapping("/ide/moduleGroup")
@Controller
public class IdeModuleGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeModuleGroupService moduleGroupService;

    /**
     * 保存组
     *
     * @param moduleGroup 组
     * @return  {@link JsonBackData}
     */
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeModuleGroup moduleGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.save(moduleGroup));
            backData.setSuccess(true);
            backData.setBackMsg("保存组成功");
        } catch (Exception e) {
            LOGGER.error("保存组失败", e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    /**
     * 删除组
     *
     * @param ids 主键数组
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{ids}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable("ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            moduleGroupService.deleteByIds(ids);
            backData.setBackMsg("删除组成功");
        }  catch (Exception e) {
            LOGGER.error("删除组失败", e);
            backData.setBackMsg("删除组错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    /**
     * 获取组
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public JsonBackData get(@PathVariable("id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.findById(id));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            LOGGER.error("查找组失败", e);
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value = "findByAppId/{appId}", method = RequestMethod.GET)
    public JsonBackData findByAppId(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.findByAppId(appId));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }
}
