package com.ejianc.foundation.front.business.ide.controller;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@SuppressWarnings("deprecation")
@RestController
@RequestMapping(value = "ide/modulePrivate")
public class IdeModulePrivateController {
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModulePrivateController.class);
	@Autowired
	IdeModulePageCache ideModulePageCache;
	@Autowired
	private IdeModulePrivateService ideModulePrivateService;

	@ResponseBody
	@RequestMapping(value = "deleteCache" ,method = RequestMethod.GET)
	public String deleteCache(String appCode, String pageCode,String orgId) {
		ideModulePageCache.removeModulePageCache(appCode,pageCode,orgId);
		return "删除成功！";
	}

	@ResponseBody
	@RequestMapping(value = "showList" ,method = RequestMethod.POST)
	public CommonResponse<IPage<IdeModulePrivate>> showList(@RequestBody Map<String, Object> query) {
		int pageNumber = (Integer) query.get("pageIndex");
		int pageSize = (Integer) query.get("pageSize");
		String code = (String) query.get("code");
		String orgId = (String) query.get("orgId");
		String appId = (String) query.get("appId");
		String tenantId = (String) query.get("tenantId");
		try {
			IPage<IdeModulePrivate> pageable = ideModulePrivateService.findByCode(pageNumber,pageSize,code,orgId,appId,tenantId);
			return CommonResponse.success(pageable);
		} catch (BusinessException e) {
			return CommonResponse.error(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			return CommonResponse.error("查询列表数据失败！");
		}
	}
	
	@ResponseBody
	@RequestMapping(value = "searchPages" ,method = RequestMethod.GET)
	public List<IdeModuleBo> searchList(String searchText,Integer limit) {
		List<IdeModuleBo> backData = new ArrayList<>();
		try {
			backData = ideModulePrivateService.searchByModuleCodeAndName(searchText,limit);
			for(IdeModuleBo module :backData){
				module.setData(module.getName());
				module.setName(module.getTeamName()+"->"+module.getAppName()+"->"+module.getName());
			}
		} catch (BusinessException e) {
			e.printStackTrace();
		}
		return backData;
	}
	
	@ResponseBody
	@RequestMapping(value = "saveOrUpdate",method = RequestMethod.POST)
	public JsonBackData saveOrUpdate(@RequestBody IdeModulePrivate bo){
		JsonBackData back = new JsonBackData();
		try {
			ideModulePrivateService.saveOrUpdate(bo);
			LOGGER.info("从缓存删除页面数据！私有化页面{}---{}---{}",bo.getAppCode(), bo.getCode(), bo.getOrgId());
			ideModulePageCache.removeModulePageCache(bo.getAppCode(),bo.getCode(),bo.getOrgId()+"");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "changeIsDevelopment", method = RequestMethod.POST)
	public JsonBackData changeIsDevelopment(@RequestBody IdeModulePrivate bo) {
		JsonBackData back = new JsonBackData();
		try {
			ideModulePrivateService.changeIsDevelopment(bo);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}

	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "delete",method = RequestMethod.POST)
	public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query){
		JsonBackData back = new JsonBackData();
		List<String> ids = (List<String>) query.get("ids");
		try {
			String idStr="";
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			List<IdeModulePrivate> pages =ideModulePrivateService.findByIds(idStr);
			ideModulePrivateService.deleteByIds(ids);
			if(ListUtil.isNotEmpty(pages)){
				for (IdeModulePrivate page : pages) {
					LOGGER.info("从缓存删除页面数据！私有化页面{}---{}---{}",page.getAppCode(), page.getCode(), page.getOrgId());
					ideModulePageCache.removeModulePageCache(page.getAppCode(),page.getCode(),page.getOrgId()+"");
				}
			}
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}

	@ResponseBody
	@RequestMapping(value = "findByCodeAndOrgId" )
	public JsonBackData findByCodeAndOrgId(String appCode,String pageCode,String orgId) {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideModulePrivateService.findByOrgIdAndCode(pageCode, appCode, orgId));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "saveData",method = RequestMethod.POST)
	public JsonBackData saveData(@RequestBody IdeModulePrivate bo){
		JsonBackData back = new JsonBackData();
		try {
			ideModulePrivateService.saveData(bo);
			LOGGER.info("从缓存删除页面数据！私有化页面{}---{}---{}",bo.getAppCode(), bo.getCode(), bo.getOrgId());
			ideModulePageCache.removeModulePageCache(bo.getAppCode(),bo.getCode(),bo.getOrgId()+"");
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "findNodeIdsHasData" )
	public JsonBackData findNodeIdsHasData(String orgId,String tenantId) {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideModulePrivateService.findNodeIds(orgId,tenantId));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "showModuleByAppId")
	public JsonBackData showAppByTeamId(@RequestParam String appId) {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideModulePrivateService.findModule(appId));
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}

	/**
	 * 导出页面json数据
	 * 
	 * @param id
	 * @param filename
	 * @param response
	 * @throws UnsupportedEncodingException
	 */
	@RequestMapping(value = "backup/{id}", method = RequestMethod.GET)
	public void backup(@PathVariable("id") String id, String filename, HttpServletResponse response)
			throws IOException {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		String fileName = new String(filename.getBytes("utf-8"), "ISO-8859-1"); // 下载的文件名显示编码处理
		response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".txt\"");
		try {
			OutputStream outputStream = response.getOutputStream();
			// 获取页面json数据
			String data = ideModulePrivateService.findById(id).getData();
			outputStream.write(data.getBytes());
			outputStream.flush();
			outputStream.close();
		} catch (BusinessException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

    /**
     * 导入的json数据直接更新保存到对应页面配置信息
     */
	@Deprecated
	@RequestMapping(value = "restore", method = RequestMethod.POST)
	public JsonBackData restore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
		try {
			// 上传的数据转成string
			ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			// 验证
			IdeModulePrivate ideModulePrivate = ideModulePrivateService.findById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModulePrivate.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData != null && oldData.get("uitype").equals(newData.get("uitype"));
			if (valide || oldData == null) {
				// 保存data
				ideModulePrivate.setModifyDate(new Date());
				ideModulePrivate.setData(myString);
				ideModulePrivateService.updateData(ideModulePrivate);
				return JsonBackData.toSuccess();

			} else {
				return JsonBackData.toError("页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError(e.getMessage());
		}
	}
    /**
     * 将导入的json数据直接返回到前端
     */
	@RequestMapping(value = "getrestore", method = RequestMethod.POST)
	public JsonBackData getRestore(@RequestParam("file") CommonsMultipartFile file, String pageId) {
		try {
			// 上传的数据转成string
			ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
			String myString = IOUtils.toString(stream, "UTF-8");
			// 验证
			IdeModulePrivate ideModulePrivate = ideModulePrivateService.findById(pageId);
			JSONObject newData = JSONObject.parseObject(myString);
			JSONObject oldData = JSONObject.parseObject(ideModulePrivate.getData());
			// 原uititle不为空，和restore的uitype页面类型相同
			boolean valide = oldData != null && oldData.get("uitype").equals(newData.get("uitype"));
			if (valide || oldData == null) {
				return JsonBackData.toSuccessData(myString);
			} else {
				return JsonBackData.toError("导入失败：页面类型不匹配");
			}
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError("导入异常："+e.getMessage());
		}
	}

	/**
	 * 更新js附件信息
	 * 
	 * @param ideModulePrivate
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "updateAttach", method = RequestMethod.POST)
	public JsonBackData updateAttach(@RequestBody IdeModulePrivate ideModulePrivate) {
		JsonBackData back = new JsonBackData();
		try {
			ideModulePrivateService.updateAttach(ideModulePrivate);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	/**
	 * 审核js附件信息
	 * 
	 * @param ideModulePrivate
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "updateAttachVerify", method = RequestMethod.POST)
	public JsonBackData updateAttachVerify(@RequestBody Map<String, Object> param) {
		JsonBackData back = new JsonBackData();
		@SuppressWarnings("unchecked")
		List<String> ids = (List<String>) param.get("ids");
		String modifyId = (String) param.get("modifyId");
		String modifyName = (String) param.get("modifyName");
		try {
			ideModulePrivateService.updateAttachVerify(ids, modifyId, modifyName);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}

	@ResponseBody
	@RequestMapping(value = "showUnverifyList", method = RequestMethod.POST)
	public JsonBackData showUnverifyList(@RequestBody Map<String, Object> query) {
		JsonBackData back = new JsonBackData();
		int pageNumber = (Integer) query.get("pageNumber");
		int pageSize = (Integer) query.get("pageSize");
		String code = (String) query.get("code");
		String orgId = (String) query.get("orgId");
		String appId = (String) query.get("appId");
		String tenantId = (String) query.get("tenantId");
		String condition = (String) query.get("condition");
		try {
			Pageable pageable = null;
			pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
			back.setBackData(
					ideModulePrivateService.findUnverifyList(code, orgId, appId, tenantId, pageable, condition));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}

	@ResponseBody
	@RequestMapping(value = "showVerifyHistoryList", method = RequestMethod.POST)
	public JsonBackData showVerifyHistoryList(@RequestBody Map<String, Object> query) {
		JsonBackData back = new JsonBackData();
		int pageNumber = (Integer) query.get("pageNumber");
		int pageSize = (Integer) query.get("pageSize");
		String code = (String) query.get("code");
		String orgId = (String) query.get("orgId");
		String appId = (String) query.get("appId");
		String tenantId = (String) query.get("tenantId");
		String condition = (String) query.get("condition");
		try {
			Pageable pageable = null;
			pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
			back.setBackData(
					ideModulePrivateService.findVerifyHistoryList(code, orgId, appId, tenantId, pageable, condition));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
}
