package com.ejianc.foundation.front.business.ide.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBillTypeRefBO;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleRefBO;
import com.ejianc.foundation.front.business.ide.bo.IdeSearchItemRefBO;
import com.ejianc.foundation.front.business.ide.service.IdeReferService;
import com.ejianc.foundation.front.business.ide.utils.refer.ReferTreeData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping(value = "ide/appRefer")
public class IdeReferController {
	
	@Autowired
	private IdeReferService ideReferService;
	
	@ResponseBody
	@RequestMapping(value = "reftree")
	public List<ReferTreeData> referTree(@RequestParam(required = false) String condition) throws BusinessException {
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		return ideReferService.referTree(paras);
	}
	
	@ResponseBody
	@RequestMapping(value = "refModuletree")
	public List<ReferTreeData> referModuleTree(@RequestParam(required = false) String condition) throws BusinessException {
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		return ideReferService.referModuleDataTree(paras);
	}
	
	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<ReferTreeData> referAppTree() throws BusinessException {
//		Map<String, Object> paras = new HashMap<String, Object>();
//		setCondition(paras, condition);
		return ideReferService.treeData();
	}
	
	/*@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "referModuleList")
	public RefPagableResponse referModuleList(
			@RequestParam(required = false, value = "pageNumber", defaultValue = "1") Integer pageNumber,
			@RequestParam(required = false, value = "pageSize", defaultValue = "10") Integer pageSize,
			@RequestParam(required = false, value = "relyCondition") String relyCondition,
			@RequestParam(required = false) String condition,
			@RequestParam(required = false, value = "searchText") String searchText
			) throws BusinessException {
		RefPagableResponse backData = new RefPagableResponse(IdeModuleRefBO.class);
		Pageable pageable = new PageRequest(pageNumber - 1, pageSize);
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		if (relyCondition != null) {
			String[] tem = relyCondition.split(",");
			for (String item : tem) {
				String[] cem = item.split("=");
				paras.put(StringUtils.trim(cem[0]), StringUtils.trim(cem[1]));
			}
		}
		if(searchText != null){
			paras.put("searchText", searchText);
		}
		try {
			List<IdeModuleRefBO> allList = ideReferService.listData(pageable, paras);
			List<IdeModuleRefBO> list = new ArrayList<>();
			for(int i = (pageNumber-1)*pageSize; i<(pageNumber*pageSize);i++){
				if (i >= allList.size() ) {
					break;
				}
				IdeModuleRefBO bo = allList.get(i);
				list.add(bo);
			}
			backData.setPageNumber(pageNumber);
			backData.setPageSize(pageSize);
			backData.setCount((long) allList.size());
			backData.setList(allList);
			backData.setCode(ReturnCode.SUCCESS);
			backData.setMsg("获取客户信息成功！");
        } catch (Exception e) {
        	backData.setCode(ReturnCode.FAILURE);
        	backData.setMsg("获取客户信息失败:"+e.getMessage());
        }
            return backData;
	}
	
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "referSearchItemList")
	public RefPagableResponse referSearchItemList(
			@RequestParam(required = false, value = "pageNumber", defaultValue = "1") Integer pageNumber,
			@RequestParam(required = false, value = "pageSize", defaultValue = "10") Integer pageSize,
			@RequestParam(required = false, value = "relyCondition") String relyCondition,
			@RequestParam(required = false) String condition,
			@RequestParam(required = false, value = "searchText") String searchText
			) throws BusinessException {
		RefPagableResponse backData = new RefPagableResponse(IdeSearchItemRefBO.class);
		Pageable pageable = new PageRequest(pageNumber - 1, pageSize);
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		if (relyCondition != null) {
			String[] tem = relyCondition.split(",");
			for (String item : tem) {
				String[] cem = item.split("=");
				paras.put(StringUtils.trim(cem[0]), StringUtils.trim(cem[1]));
			}
		}
		if(searchText != null){
			paras.put("searchText", searchText);
		}
		try {
			Page<IdeSearchItemRefBO> page = ideReferService.searchItemList(pageable, paras);
			backData.setPageNumber(pageNumber);
			backData.setPageSize(pageSize);
			backData.setCount(page.getTotalElements());
			backData.setList(page.getContent());
			backData.setCode(ReturnCode.SUCCESS);
			backData.setMsg("获取客户信息成功！");
        } catch (Exception e) {
        	backData.setCode(ReturnCode.FAILURE);
        	backData.setMsg("获取客户信息失败:"+e.getMessage());
        }
            return backData;
	}*/
	
	//搜索栏子项树表页面的页面树
	@ResponseBody
	@RequestMapping(value = "refPageTree")
	public List<ReferTreeData> referPageTree(@RequestParam(required = false) String condition) throws BusinessException {
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		return ideReferService.pageTreeData(paras);
	}
	
	/*//搜索栏子项树表页面的表数据
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "refSearchItemList")
	public RefPagableResponse refSearchItemList(
			@RequestParam(required = false, value = "pageNumber", defaultValue = "1") Integer pageNumber,
			@RequestParam(required = false, value = "pageSize", defaultValue = "10") Integer pageSize,
			@RequestParam(required = false, value = "relyCondition") String relyCondition,
			@RequestParam(required = false) String condition,
			@RequestParam(required = false, value = "searchText") String searchText
			) throws BusinessException {
		RefPagableResponse backData = new RefPagableResponse(IdeSearchItemRefBO.class);
		Map<String, Object> paras = new HashMap<String, Object>();
		setCondition(paras, condition);
		if (relyCondition != null) {
			String[] tem = relyCondition.split(",");
			for (String item : tem) {
				String[] cem = item.split("=");
				paras.put(StringUtils.trim(cem[0]), StringUtils.trim(cem[1]));
			}
		}
		if(searchText != null){
			paras.put("searchText", searchText);
		}
		try {
			List<IdeSearchItemRefBO> allList = ideReferService.searchItemListByPageId(paras);
			backData.setPageNumber(pageNumber);
			backData.setPageSize(pageSize);
			backData.setCount((long) allList.size());
			backData.setList(allList);
			backData.setCode(ReturnCode.SUCCESS);
			backData.setMsg("获取客户信息成功！");
        } catch (Exception e) {
        	backData.setCode(ReturnCode.FAILURE);
        	backData.setMsg("获取客户信息失败:"+e.getMessage());
        }
            return backData;
	}
	
	  ////单据类型-页面参照的页面列表
		@SuppressWarnings("unchecked")
		@ResponseBody
		@RequestMapping(value = "moduleByBillTypeList")
		public RefPagableResponse moduleByBillTypeList(
				@RequestParam(required = false, value = "pageNumber", defaultValue = "1") Integer pageNumber,
				@RequestParam(required = false, value = "pageSize", defaultValue = "10") Integer pageSize,
				@RequestParam(required = false, value = "relyCondition") String relyCondition,
				@RequestParam(required = false) String condition,
				@RequestParam(required = false, value = "searchText") String searchText
				) throws BusinessException {
			RefPagableResponse backData = new RefPagableResponse(IdeModuleBillTypeRefBO.class);
			Pageable pageable = new PageRequest(pageNumber - 1, pageSize);
			Map<String, Object> paras = new HashMap<String, Object>();
			if (relyCondition != null) {
				String[] tem = relyCondition.split(",");
				for (String item : tem) {
					String[] cem = item.split("=");
					paras.put(StringUtils.trim(cem[0]), StringUtils.trim(cem[1]));
				}
			}
			if(searchText != null){
				paras.put("searchText", searchText);
			}
			try {
				Page<IdeModuleBillTypeRefBO> page = ideReferService.moduleListByBillType(paras, pageable);
				backData.setPageNumber(pageNumber);
				backData.setPageSize(pageSize);
				backData.setCount(page.getTotalElements());
				backData.setList(page.getContent());
				backData.setCode(ReturnCode.SUCCESS);
				backData.setMsg("获取客户信息成功！");
	        } catch (Exception e) {
	        	backData.setCode(ReturnCode.FAILURE);
	        	backData.setMsg("获取客户信息失败:"+e.getMessage());
	        }
	            return backData;
		}*/
	
	private void setCondition(Map<String, Object> paras, String condition) {
		JSONObject object = JSONObject.parseObject(condition);
		String def = null;
		if (!object.isEmpty()) {
			if (object.get("moduleCode") != null) {
				def = (String) object.get("moduleCode");
				if (def != null)
					paras.put("moduleCode", def);
			}
			if (object.get("moduleName") != null) {
				String orgId = (String) object.get("moduleName");
				if (orgId != null)
					paras.put("moduleName", orgId);
			}
			if (object.get("appCode") != null) {
				def = (String) object.get("appCode");
				if (def != null)
					paras.put("appCode", def);
			}
			if (object.get("appName") != null) {
				String orgId = (String) object.get("appName");
				if (orgId != null)
					paras.put("appName", orgId);
			}
			if (object.get("uitype") != null) {
				String uiTypes =  (String) object.get("uitype");
				if (uiTypes != null)
					paras.put("uitype", uiTypes);
			}
			if (object.get("billType") != null) {
				String uiTypes =  (String) object.get("billType");
				if (uiTypes != null)
					paras.put("billType", uiTypes);
			}
			if (object.get("isSort") != null) {
				String isSort =  (String) object.get("isSort");
				if (isSort != null)
					paras.put("isSort", isSort);
			}
		}

	}
	

}
