package com.ejianc.foundation.front.business.ide.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.UserMessageType;
import com.ejianc.foundation.front.business.ide.service.IdeUserMessageService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 用户消息controller
 * Created by cdr_c on 2017/8/3.
 */
@RequestMapping("ide/userMessage")
@RestController
public class IdeUserMessageController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleDataController.class);
    @Autowired
    private IdeUserMessageService userMessageService;

    /**
     * 获取用户消息
     *
     * @param userId 用户id
     * @return 消息类型数组
     */
    @RequestMapping
    public JsonBackData getApplyJoinMessage(String userId, UserMessageType[] messageTypes) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(userMessageService.getUserMessage(userId, messageTypes));
            backData.setBackMsg("成功");
        } catch (BusinessException e) {
            LOGGER.error("获取用户消息异常", e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("获取用户消息异常", e);
            backData.setSuccess(false);
            backData.setBackMsg("获取用户消息异常" + e.getMessage());
        }
        return backData;
    }

}
