package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;

@Mapper
public interface IdeModuleRepo extends BaseCrudMapper<IdeModule> {

    List<IdeModule> findByAppId(@Param("appId") String appId);
    
    List<String> findModuleIdsByAppId(@Param("appId") String appId);

    List<IdeModule> findAll(@Param("clientType") String clientType);

    void deleteById(@Param("id") String id);

    void deleteByIds(@Param("ids") String ids);

    IdeModule findById(@Param("id") String id);

    List<IdeModule> findByCodeOrName(@Param("code") String code,@Param("name") String name,@Param("appId") String appId);

    List<IdeModule> findByName(@Param("name") String name,@Param("appId") String appId);
    
    IdeModule findByCode(@Param("code") String code,@Param("appId") String appId);
    
    List<IdeModule> findAllByCode(@Param("code") String code);
    
    IdeModule findByAppCodeAndModuleCode(@Param("appCode") String appCode,@Param("moduleCode") String moduleCode);
    
    IdeModuleBo findDetailById(@Param("id") String id);

    List<IdeModule> findDetailsByAppId(@Param("appId") String appId);

    List<IdeModule> findModulesByAppId(@Param("appId") String appId, @Param("isDelete") Integer isDelete);

    List<IdeModule> findByUserId(@Param("userId") String userId);
    
    void removeByIds(@Param("ids") String ids);
    
    //恢复逻辑删除的页面
    void recoverByIds(@Param("ids") String ids);
    
    //根据appId恢复逻辑删除的页面
    void recoverByAppIds(@Param("appId") String appId);
    
    void movePagesByAppId(@Param("pageIds") String pageIds, @Param("appId") String appId);
    
    List<IdeModule> findByIds(@Param("ids") String ids);

	void save(IdeModule ideModule);

	void update(IdeModule ideModule);

	void updateGroupId(@Param("groupIds") String groupIds);

	List<IdeModule> findInAppIds(@Param("appIds") String appIds);

	List<IdeModule> findModuleListByAppId(@Param("appId") String appId,@Param("searchText") String searchText,
			@Param("isDelete") boolean isDelete,@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

	Long findModuleCountByAppId(@Param("appId") String appId,@Param("searchText") String searchText,
			@Param("isDelete") boolean isDelete);

	List<IdeModuleBo> queryListByModuleCodeAndName(@Param("searchText") String searchText,@Param("maxCount") int maxCount);

	List<IdeModule> queryPageHasData(@Param("orgIds") String orgIds);

    List<IdeModule> findListBySql(@Param("appCodesParam") String appCodesParam );
}
