package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.bo.IdeUserBo;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;

/**
 * 用户表相关查询
 * @author Dio
 *
 */
@Mapper
public interface IdeUserRepo {
	/**
	 * 查找账号
	 * @param code 账号
	 * @param password 密码(加密值)
	 * @return
	 */
	IdeUser selectAccount(@Param("code") String code,@Param("password") String password);
	
	/**
	 * 查找账号
	 * @param code 账号
	 * @return
	 */
	List<IdeUser> selectAccountByCode(@Param("code") String code);
	
	/**
	 * 通过QQ的OpenId查找账号信息
	 * @return
	 */
	IdeUser selectByQQOpenId(@Param("qqOpenId") String qqOpenId);

	/**
	 * 保存用户
	 * 
	 * @param newUser
	 * @return
	 */
	void save(IdeUser newUser);

	/*
	 * 修改用户
	 */
	void update(IdeUser ideUser);

	List<IdeUserBo> findUsers(@Param("teamId") String teamId);

	List<Map<String, Object>> findMapByTeamId(@Param("teamIds") String teamIds);
}
