package com.ejianc.foundation.front.business.ide.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdePartWidget;
import com.ejianc.foundation.front.business.ide.repository.IdePartWidgetRepo;

@Service
@Transactional
public class IdePartWidgetService {
    @Autowired
    IdePartWidgetRepo idePartWidgetRepo;
    public IdePartWidget saveOrUpdate(IdePartWidget idePartWidget) {
        if (idePartWidget.getId() != null && idePartWidget.getId() > 0) {
            idePartWidget.setCreateDate(new Date());
            idePartWidgetRepo.save(idePartWidget);
            return idePartWidget;
        }else{
            IdePartWidget idePartWidgetUpdate = idePartWidgetRepo.findById(String.valueOf(idePartWidget.getId()));
            idePartWidgetUpdate.setModifyDate(new Date());
            idePartWidgetUpdate.setModifyId(idePartWidget.getCreateId());
            idePartWidgetUpdate.setData(idePartWidget.getData());
            idePartWidgetRepo.save(idePartWidgetUpdate);
            return idePartWidgetUpdate;
        }
    }

    public List<IdePartWidget> findByCreateId(String userId) {
        return idePartWidgetRepo.findByCreateId(userId);
    }

	public List<IdePartWidget> deleteById(IdePartWidget idePartWidget ) {
		idePartWidgetRepo.deleteById(String.valueOf(idePartWidget.getId()));
		return idePartWidgetRepo.findByCreateId(String.valueOf(idePartWidget.getCreateId()));
		
	}
    
}
