package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.ApplyJoinMessageBO;
import com.ejianc.foundation.front.business.ide.bo.UserMessageType;

/**
 * 用户消息service
 * Created by cdr_c on 2017/8/3.
 */
public interface IdeUserMessageService {

    /**
     * 获取申请加入的消息
     *
     * @param userId 用户id
     * @return 申请加入的消息
     */
    List<ApplyJoinMessageBO> getApplyJoinMessage(String userId);

    /**
     * 获取用户消息
     * @param userId 用户id
     * @param messageTypes 消息类型数组
     * @return 用户消息 
     */
    JSONObject getUserMessage(String userId, UserMessageType[] messageTypes);
}
