package com.ejianc.foundation.front.business.ide.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.entity.IdeEntityAttr;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityAttrRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEntityAttrService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Service
@Transactional
public class IdeEntityAttrServiceImpl implements IdeEntityAttrService{

	@Autowired
	private IdeEntityAttrRepo entityAttrRepo;
	@Autowired
	private IdeEntityRepo entityRepo;
	@Override
	public IdeEntity save(List<IdeEntityAttr> ideEntityAttrs, String entityId,int version) throws Exception, BusinessException {
		for (IdeEntityAttr ideEntityAttr : ideEntityAttrs) {
			if (ideEntityAttr.getRowState().equals("del")) {
				ideEntityAttrs.remove(ideEntityAttr);
			}
		}
		IdeEntity entity = entityRepo.findById(entityId);
		if (entity == null) {
			throw new BusinessException("本模型被他人删除，请刷新获取最新数据！");
		}
		if (version!= entity.getVersion()) {
            throw new BusinessException(String.format("本模型被他人于[%s]修改过，请刷新获取最新数据！",
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getModifyDate())));
        }
		
		List<String> list = new ArrayList<>();
		String errData = "";
		for (IdeEntityAttr ideEntityAttr : ideEntityAttrs) {
			if (list.contains(ideEntityAttr.getCode())) {
				errData += ideEntityAttr.getCode()+",";
			}else {
				list.add(ideEntityAttr.getCode());
			}
		}
		if (errData.equals("")) {
			entityAttrRepo.deleteEntityId(entityId);
			if(ideEntityAttrs != null && ideEntityAttrs.size() > 0) {
				for(IdeEntityAttr ideEntityAttr:ideEntityAttrs) {
					ideEntityAttr.setId(IdWorker.getId());
					entityAttrRepo.save(ideEntityAttr);
				}
			}
			entity.setModifyDate(new Date());
			entity.setModifyId(InvocationInfoProxy.getUserid());
			entityRepo.update(entity);
			return  entity;
		}else {
			throw new BusinessException("键值"+errData.substring(0,errData.length()-1)+"不能重复！");
		}
		
	}

	@Override
	public List<IdeEntityAttr> findListByEntityId(String entityId) throws Exception, BusinessException {
		return entityAttrRepo.findByEntityId(entityId);
	}
	
	

}
