package com.ejianc.foundation.front.business.ide.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;

public class UiDefineToJsonUtil {
	
	/**
	 * 将IdeUiDefine解析为界面设计器前端需要的类型数组
	 * @param data  数据源
     * @return
	 * */
	@SuppressWarnings("serial")
	public static JSONObject uiDefineToJson(List<IdeUiDefine> data) {
		if(data != null && data.size() > 0){
			String allUiDefine = String.join(",", (data.stream().map(IdeUiDefine::getCode).collect(Collectors.toList())));
			JSONObject backData = new JSONObject(new HashMap<String,Object>(){{
				Map<String, Object> uiTypeDef = new HashMap<>();
				Map<String, Object> uiTitleDef = new HashMap<>();
				Map<String, Object> uiDefaultDef = new HashMap<>();
				Map<String, Object> uiIconDef = new HashMap<>();
				Map<String, Object> uiSubDef = new HashMap<>();
				for (IdeUiDefine uiDefine : data) {
					uiTypeDef.put(uiDefine.getCode(), uiDefine.getParser());
					uiTitleDef.put(uiDefine.getCode(), uiDefine.getName());
					uiDefaultDef.put(uiDefine.getCode(), uiDefine.getDefaults());
					uiIconDef.put(uiDefine.getCode(), uiDefine.getIcon());
					if (uiDefine.getIncludeType().equals("part")) {
						uiSubDef.put(uiDefine.getCode(), uiDefine.getIncludeContents());
					}else if (uiDefine.getIncludeType().equals("all")) {
						uiSubDef.put(uiDefine.getCode(), allUiDefine);
					}	
				}
				put("UiTypeDef", uiTypeDef);
				put("UiTitleDef", uiTitleDef);
				put("UiDefaultDef", uiDefaultDef);
				put("UiIconDef", uiIconDef);
				put("UiSubDef", uiSubDef);
			}});
			return backData;
		}
		return null;
	}

}
