package com.ejianc.foundation.front.business.ide.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.service.IdeTotalService;
import com.ejianc.foundation.front.util.JsonBackData;

@Controller
@RequestMapping(value = "ide/total")
public class IdeTotalController {
	
	@Autowired
	private IdeTotalService ideTotalService;
	
	@ResponseBody
	@RequestMapping(value = "showPageTotal")
	public JsonBackData showList() {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideTotalService.showTotal(0));
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询数据失败！");
		}
		return back;
	}

}
