package com.ejianc.foundation.front.business.ide.controller.api;

import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
public class FrontCfsPageApi implements IFrontApi {
	@Autowired
	IdeModuleRepo ideModuleRepo;
	@Autowired
	IdeModuleService ideModuleService;

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/12/7  新建 cfs 页面
	 * @Description insertNewCfsPage
	 * @Param [ideModuleVO]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 * @param ideModuleVO
	 */
	@Override
	@RequestMapping(value = "/api/page/insertNewCfsPage", method = RequestMethod.POST)
	public CommonResponse<IdeModuleVO> insertNewCfsPage(IdeModuleVO ideModuleVO) {
		if(ideModuleVO == null || !ideModuleVO.getCode().startsWith("CFS")){
			return CommonResponse.error("页面为空或者pageCode非法！");
		}
		if(ideModuleVO.getId() == null || ideModuleVO.getId() == 0){
			return CommonResponse.error("页面主键不能为空！");
		}
		if (StringUtils.isEmpty(ideModuleVO.getName())) {
			return CommonResponse.error("页面名称不能为空！");
		}
		IdeModule ideModule = ideModuleService.findByCode(ideModuleVO.getCode());
		if(ideModule != null){
			/** 移动端可能会更新 */
			ideModule.setData(ideModuleVO.getData());
			ideModuleRepo.update(ideModule);
			return CommonResponse.success(BeanMapper.map(ideModule,IdeModuleVO.class));
		}else {
			ideModule = BeanMapper.map(ideModuleVO,IdeModule.class);
		}
		try {
			ideModuleRepo.save(ideModule);
		} catch (Exception e) {
			e.printStackTrace();
			return CommonResponse.error("新建页面出现异常："+e.getMessage());
		}
		return CommonResponse.success(BeanMapper.map(ideModule,IdeModuleVO.class));
	}
}
