package com.ejianc.foundation.front.business.ide.repository;

import java.util.ArrayList;
import java.util.List;

import com.ejianc.foundation.front.business.ide.bo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeTeam;

@Mapper
public interface IdeTeamRepo {

    /**
     * 查找团队下所有用户
     *
     * @param id 主键
     * @return 用户集合
     */
    List<IdeUserBo> findUsers(@Param("id") String id);

    /**
     * 统计团队下用户人数（角色类型非超级管理员且加入状态为in）
     *
     * @return 用户人数
     */
    int countTeamUsers(@Param("teamId") String teamId);
    /**
     * 统计团队下应用数
     *
     * @return 应用数
     */
    int countTeamApps(@Param("teamId") String teamId);
    
    //根据多个id查询团队
    List<IdeTeam> findByIds(@Param("ids") String ids);
    
    List<IdeTeam> findAllByCode(@Param("code") String code);
    
    //根据类型查询团队
    List<IdeTeam> findTeamByProdType(@Param("proType") Integer proType);

    List<IdeModuleBo> searchByAppName(@Param("searchText") String searchText, @Param("maxCount") int maxCount);

    void deleteByIds(@Param("ids") String ids);
    
    //恢复删除
    void recoverByIds(@Param("ids") String ids);
    
    //彻底删除
    void removeByIds(@Param("ids") String ids);
    
    /**
     * 根据应用id查询团队
     *
     * @return 应用数
     */
    List<IdeTeam> findTeamByAppIds(@Param("appIds") String appIds);

	IdeTeam findOne(@Param("id") String id);

	void save(IdeTeam ideTeam);

	ArrayList<IdeTeam> findAll(@Param("teamIds") String teamIds);

	void update(IdeTeam ideTeam);

	IdeTotalBO queryTeamTotal(@Param("prodType") int prodType);

	void logicDel(@Param("id") String id);

	List<IdeTeamBo> queryUserTeams(@Param("userId") String userId,@Param("prodType") Integer prodType);

	List<ApplyJoinMessageBO> findApplyListByUserId(@Param("userId") String userId);

	List<IdeTeamBo> queryTeamList(@Param("searchText") String searchText,@Param("prodType") int prodType,@Param("isDelete") boolean isDelete,
			@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

	Long queryTeamCount(@Param("searchText") String searchText,@Param("prodType") int prodType,@Param("idDelete") boolean isDelete);

	List<IdeTeamBo> queryForPageList(@Param("key") String key,@Param("prodType") int prodType,@Param("userId") String userId,
			@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

	Long queryForPageCount(@Param("key") String key,@Param("prodType") int prodType,@Param("userId") String userId);

	List<IdeTeam> findTeamHasData(@Param("orgIds") String orgIds);

    List<IdeTeam> findListBySql(@Param("teamCodesParam") String teamCodesParam);

}
