package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

/**
 * 页面相关服务定义
 */
public interface IdeModuleService {

    List<IdeModule> findByAppId(String appId) throws Exception;
    /**
     * 通过应用ids获取页面集合
     * 只获取页面的基本信息id、name、code、appId
     */
    List<IdeModule> findInAppIds(String[] appIds);
    List<IdeModule> findByGroupIds(String[] groupIds);
    IdeModule findByCode(String moduleCode);
    IdeModule findEntityById(String id);
    IdeModuleBo findById(String id) throws Exception;
    List<IdeModule> findIsDeleteModules(String appId) throws Exception;
    
    IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode);
    Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String moduleCode,String orgId,String tenantId);

    void deleteById(String id) throws Exception;

    IdeModule saveOrUpdate(IdeModule ideModule) throws Exception;
    /**
     * 同步服务的发布方：将开发环境的数据发布给生产环境
     * @throws Exception
     */
    JsonBackData syncPublishProduction(String appId, List<String> pageIds,String fromName,String toName) throws Exception;
    
    /**
     * 同步服务的接收方：生产环境上接收数据进行还原
     * @param production
     * @throws Exception
     */
    JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception;

    void updatePrivatePage(List<IdeModule> pages);
    /**
     * 将已发布的页面备份到发布历史纪录表
     */
    void publishHistory(IdeModule ideModule, String fromName, String toName);

    void copyModule(IdeModule ideModule) throws Exception;
    
    //根据appId查询分页页面 当appId为空时查询所有页面
    Page<IdeModule> findModulesByAppId(String appId,String searchText,boolean isDelete,Pageable pageable) throws Exception;
    
    //根据页面id查询是否存在已发布页面或进行过页面配置的页面
    List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException,Exception;
    //批量删除（或彻底删除）页面
    void deleteByIds(List<String> ids,boolean isRemove) throws BusinessException,Exception;
    //恢复被逻辑删除的数据
    void restoreByIds(List<String> ids) throws BusinessException,Exception;
    
    JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException,Exception;

    List<IdeModule> findByIds(List<String> ids);
}
