package com.ejianc.foundation.front.business.ide.service;

import com.alibaba.fastjson.JSONObject;

/**
 * 读取实体元数据信息，自动创建单据页面
 *
 * @author cdrcool
 */
public interface MetadataReaderService {

    /**
     * 获取实体元数据
     *
     * @param billType 单据类型id
     * @return 实体元数据
     */
    JSONObject getMetadata(String billType);

    /**
     * 读取实体元数据
     * 
     * @param billType 单据类型
     * @param entityId 元数据id
     * @param pageType   页面类型
     * @return 页面元数据
     */
    JSONObject readMetadata(String billType, String entityId, String pageType);
}
