/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeProductAppBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeAppOpenService;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appopen"})
public class IdeAppOpenController {
    @Autowired
    IdeAppOpenService ideAppOpenService;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppGroupService ideAppGroupService;
    @Autowired
    IdeModuleService ideModuleService;

    @RequestMapping(value={"product/saveapp"}, method={RequestMethod.POST})
    public JsonBackData saveAppForProduct(@RequestBody IdeApp ideApp) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppOpenService.saveAppForProduct(ideApp);
            backData.setSuccess(true);
            backData.setBackMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"product/removeapp"}, method={RequestMethod.POST})
    public JsonBackData removeAppForProduct(@RequestParam String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppService.deleteById(id);
            backData.setBackMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"product/apps"}, method={RequestMethod.GET})
    public JsonBackData findProductApps(String productId) {
        JsonBackData backData = new JsonBackData();
        try {
            IdeProductAppBo productApps = this.ideAppOpenService.findAppByProduct(productId);
            backData.setBackData(productApps);
            backData.setBackMsg("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"product/appcount"}, method={RequestMethod.GET})
    public JsonBackData findProductAppCount(String[] productIds) {
        JsonBackData backData = new JsonBackData();
        try {
            Map<String, Integer> productAppCount = this.ideAppOpenService.findProductAppCount(Arrays.asList(productIds));
            backData.setBackData(productAppCount);
            backData.setBackMsg("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"product/saveappgroup"}, method={RequestMethod.POST})
    public JsonBackData saveAppGroupForProduct(@RequestBody IdeAppGroup appGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.ideAppOpenService.saveAppGroupForProduct(appGroup));
            backData.setSuccess(true);
            backData.setBackMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (BusinessException e) {
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            backData.setSuccess(false);
            backData.setBackMsg("\u4fdd\u5b58\u6587\u4ef6\u5939\u5f02\u5e38");
        }
        return backData;
    }

    @RequestMapping(value={"product/removeappgroup"}, method={RequestMethod.POST})
    public JsonBackData removeAppGroupForProduct(@RequestParam String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.ideAppGroupService.deleteByIds(new String[]{id});
            backData.setBackMsg("\u5220\u9664\u6210\u529f");
        }
        catch (BusinessException e) {
            backData.setBackMsg(e.getMessage());
            backData.setSuccess(false);
        }
        catch (Exception e) {
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"product/apppages"}, method={RequestMethod.GET})
    public JsonBackData findPageByProductApp(String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            List<IdeModule> modules = this.ideAppOpenService.findPageByProductApp(appId);
            backData.setBackData(modules);
            backData.setBackMsg("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            backData.setBackMsg("\u7cfb\u7edf\u9519\u8bef");
            backData.setBackData(e.getMessage());
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"product/saveapppage"}, method={RequestMethod.POST})
    public JsonBackData saveAppPageForProduct(@RequestBody IdeModule ideModule) throws BusinessException, Exception {
        try {
            IdeModule module = this.ideModuleService.saveOrUpdate(ideModule);
            return JsonBackData.toSuccess("\u4fdd\u5b58\u6210\u529f", module);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }

    @RequestMapping(value={"product/removeapppage"}, method={RequestMethod.POST})
    public JsonBackData removeAppPageForProduct(@RequestParam String id) throws Exception {
        try {
            this.ideModuleService.deleteById(id);
            return JsonBackData.toSuccess("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
}

