/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.entity.IdeDocument;
import com.ejianc.foundation.front.business.ide.service.IdeDocumentService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/ide/document"})
@Controller
public class IdeDocumentController {
    @Autowired
    private IdeDocumentService ideDocumentService;

    @RequestMapping(value={"showList/{docType}"}, method={RequestMethod.GET})
    public JsonBackData showList(@PathVariable int docType) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideDocumentService.findByDocType(docType));
            back.setSuccess(true);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public JsonBackData saveOrUpdate(@RequestBody IdeDocument document) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideDocumentService.saveOrUpdate(document);
            back.setSuccess(true);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        try {
            this.ideDocumentService.deleteByIds(ids.toArray(new String[ids.size()]));
            back.setSuccess(true);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @RequestMapping(value={"showAll"}, method={RequestMethod.GET})
    public JsonBackData showAll() {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideDocumentService.findAll());
            back.setSuccess(true);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }
}

