/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.entity.IdeEntityAttr;
import com.ejianc.foundation.front.business.ide.service.IdeEntityAttrService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/entityAttr"})
public class IdeEntityAttrController {
    @Autowired
    private IdeEntityAttrService ideEntityAttrService;

    @ResponseBody
    @RequestMapping(value={"showList"})
    public JsonBackData showList(@RequestParam String entityId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideEntityAttrService.findListByEntityId(entityId));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public JsonBackData saveOrUpdate(@RequestBody Map<String, Object> map) {
        JsonBackData back = new JsonBackData();
        List data = (List)map.get("list");
        String entityId = (String)map.get("entityId");
        int version = (Integer)map.get("version");
        try {
            ArrayList<IdeEntityAttr> ideEntityAttrs = new ArrayList<IdeEntityAttr>();
            IdeEntityAttr ideEntityAttr = null;
            if (data != null && data.size() > 0) {
                for (Map object : data) {
                    ideEntityAttr = new IdeEntityAttr();
                    ideEntityAttr.setCode((String)object.get("code"));
                    ideEntityAttr.setName((String)object.get("name"));
                    ideEntityAttr.setDataType((String)object.get("dataType"));
                    ideEntityAttr.setLen((Integer)object.get("len"));
                    ideEntityAttr.setRowState((String)object.get("rowState"));
                    ideEntityAttr.setEntityId((Long)object.get("entityId"));
                    ideEntityAttr.setIsArray((Boolean)object.get("isArray"));
                    ideEntityAttrs.add(ideEntityAttr);
                }
            }
            back.setBackData(this.ideEntityAttrService.save(ideEntityAttrs, entityId, version));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }
}

