/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.service.IdeReferService;
import com.ejianc.foundation.front.business.ide.utils.refer.ReferTreeData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/appRefer"})
public class IdeReferController {
    @Autowired
    private IdeReferService ideReferService;

    @ResponseBody
    @RequestMapping(value={"reftree"})
    public List<ReferTreeData> referTree(@RequestParam(required=false) String condition) throws BusinessException {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setCondition(paras, condition);
        return this.ideReferService.referTree(paras);
    }

    @ResponseBody
    @RequestMapping(value={"refModuletree"})
    public List<ReferTreeData> referModuleTree(@RequestParam(required=false) String condition) throws BusinessException {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setCondition(paras, condition);
        return this.ideReferService.referModuleDataTree(paras);
    }

    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<ReferTreeData> referAppTree() throws BusinessException {
        return this.ideReferService.treeData();
    }

    @ResponseBody
    @RequestMapping(value={"refPageTree"})
    public List<ReferTreeData> referPageTree(@RequestParam(required=false) String condition) throws BusinessException {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setCondition(paras, condition);
        return this.ideReferService.pageTreeData(paras);
    }

    private void setCondition(Map<String, Object> paras, String condition) {
        JSONObject object = JSONObject.parseObject((String)condition);
        String def = null;
        if (!object.isEmpty()) {
            String isSort;
            String uiTypes;
            String orgId;
            if (object.get((Object)"moduleCode") != null && (def = (String)object.get((Object)"moduleCode")) != null) {
                paras.put("moduleCode", def);
            }
            if (object.get((Object)"moduleName") != null && (orgId = (String)object.get((Object)"moduleName")) != null) {
                paras.put("moduleName", orgId);
            }
            if (object.get((Object)"appCode") != null && (def = (String)object.get((Object)"appCode")) != null) {
                paras.put("appCode", def);
            }
            if (object.get((Object)"appName") != null && (orgId = (String)object.get((Object)"appName")) != null) {
                paras.put("appName", orgId);
            }
            if (object.get((Object)"uitype") != null && (uiTypes = (String)object.get((Object)"uitype")) != null) {
                paras.put("uitype", uiTypes);
            }
            if (object.get((Object)"billType") != null && (uiTypes = (String)object.get((Object)"billType")) != null) {
                paras.put("billType", uiTypes);
            }
            if (object.get((Object)"isSort") != null && (isSort = (String)object.get((Object)"isSort")) != null) {
                paras.put("isSort", isSort);
            }
        }
    }
}

