/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironment;
import com.ejianc.foundation.front.business.ide.service.IdeAccountService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeReleaseService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/release"})
public class IdeReleaseController {
    private static final Logger log = LoggerFactory.getLogger(IdeReleaseController.class);
    @Autowired
    private IdeReleaseService releaseService;
    @Autowired
    private IdeEnvironmentService ideEnvironmentService;
    @Autowired
    private IdeAccountService accountService;

    @ResponseBody
    @RequestMapping(value={"release"}, method={RequestMethod.POST})
    public JsonBackData release(@RequestBody Map<String, Object> params) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        String version = (String)params.get("version");
        Map appList = (Map)params.get("appList");
        try {
            this.releaseService.releaseAppIds(appList, version);
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u53d1\u7248\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findReleases"}, method={RequestMethod.GET})
    public JsonBackData findReleases(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.findReleases(appId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u83b7\u53d6\u7248\u672c\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findReleasePages"}, method={RequestMethod.GET})
    public JsonBackData findReleasePages(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.findReleasePages(releaseGroupId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u83b7\u53d6\u53d1\u7248\u9875\u9762\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"online"}, method={RequestMethod.GET})
    public JsonBackData online(HttpServletRequest request, String releaseGroupId, String envUrl) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            IdeAccountBo currUser = this.accountService.getCurrUser(request);
            if (currUser == null) {
                back.setSuccess(false);
                back.setBackMsg("\u4e0a\u7ebf\u5931\u8d25\uff1a\u5f53\u524d\u8d26\u53f7\u5df2\u767b\u5f55\u5931\u6548\u8bf7\u91cd\u65b0\u767b\u5f55\u540e\u518d\u53d1\u5e03\uff01");
                return back;
            }
            IdeEnvironment environment = this.ideEnvironmentService.findByUrl(envUrl);
            if (environment == null) {
                back.setSuccess(false);
                back.setBackMsg("\u4e0a\u7ebf\u5931\u8d25\uff1a\u76ee\u6807\u73af\u5883" + envUrl + "\u672a\u6ce8\u518c\uff01");
                return back;
            }
            if (StringUtils.isNotEmpty(environment.getPublishUser()) && !environment.getPublishUser().contains(currUser.getCode())) {
                back.setSuccess(false);
                back.setBackMsg("\u4e0a\u7ebf\u5931\u8d25\uff1a\u4f60\u6ca1\u6709\u76ee\u6807\u73af\u5883" + envUrl + "\u4e0a\u7ebf\u6743\u9650\uff01");
                return back;
            }
            this.releaseService.online(releaseGroupId, envUrl);
        }
        catch (Exception e) {
            log.error("\u4e0a\u7ebf\u5931\u8d25\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u4e0a\u7ebf\u5931\u8d25\uff1a" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"exportTextToTxt"}, method={RequestMethod.GET})
    public void exportTextToTxt(@RequestParam String releaseGroupId, HttpServletResponse response) throws IOException {
        JSONObject onlineText = this.releaseService.getOnlineText(releaseGroupId);
        String textContent = onlineText.getString("textContent");
        byte[] contentBytes = textContent.getBytes(StandardCharsets.UTF_8);
        String fileName = onlineText.getString("version");
        try {
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        }
        catch (IOException e) {
            log.error("Error encoding file name", (Throwable)e);
            fileName = "default.txt";
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setContentLength(contentBytes.length);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(contentBytes);
            outputStream.flush();
        }
        catch (IOException e) {
            log.error("Error writing to output stream", (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"viewOnlineHistory"}, method={RequestMethod.GET})
    public JsonBackData viewOnlineHistory(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(this.releaseService.viewOnlineHistory(appId));
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u770b\u4e0a\u7ebf\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"deleteVersion"}, method={RequestMethod.GET})
    public JsonBackData deleteVersion(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            this.releaseService.deleteVersion(releaseGroupId);
        }
        catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u770b\u4e0a\u7ebf\u5386\u53f2\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
        return back;
    }
}

