/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeTeamDatasource;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamDatasourceRepo;
import com.ejianc.foundation.front.business.ide.service.IdeTeamDatasourceService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class IdeTeamDatasourceServiceImpl
implements IdeTeamDatasourceService {
    @Autowired
    private IdeTeamDatasourceRepo datasourceRepo;

    @Override
    @Transactional
    public List<IdeTeamDatasource> updateTeamDatasource(String teamId, String[] datasourceCodes) {
        if (datasourceCodes != null && datasourceCodes.length > 0) {
            for (String datasourceCode : datasourceCodes) {
                IdeTeamDatasource datasource = new IdeTeamDatasource();
                datasource.setId(IdWorker.getId());
                datasource.setCode(String.valueOf(IdWorker.getId()));
                datasource.setCreateDate(new Date());
                datasource.setTeamId(Long.parseLong(teamId));
                datasource.setSourceCode(datasourceCode);
                this.datasourceRepo.save(datasource);
            }
        }
        this.datasourceRepo.deleteByTeamId(teamId);
        return null;
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        IdeTeamDatasource datasource = this.datasourceRepo.findOne(id);
        if (datasource == null) {
            throw new BusinessException("\u8be5\u56e2\u961f\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!");
        }
        this.datasourceRepo.logicDel(datasource.getId());
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        Arrays.stream(ids).forEach(this::deleteById);
    }

    @Override
    public IdeTeamDatasource findById(String id) {
        return this.datasourceRepo.findOne(id);
    }

    @Override
    public List<IdeTeamDatasource> findByTeamId(String teamId) {
        return this.datasourceRepo.findByTeamId(teamId);
    }
}

