package com.ejianc.foundation.front.business.ide.controller;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.service.IdeEntityService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@Controller
@RequestMapping(value = "ide/entity")
public class IdeEntityController {
	
	@Autowired
	private IdeEntityService ideEntityService;
	
	@ResponseBody
	@RequestMapping(value = "showList" )
	public JsonBackData showList(@RequestParam String appId) {
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideEntityService.findListByAppId(appId));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}
	
	
	@ResponseBody
	@RequestMapping(value = "saveOrUpdate",method = RequestMethod.POST)
	public JsonBackData saveOrUpdate(@RequestBody IdeEntity bo){
		JsonBackData back = new JsonBackData();
		try {
			back.setBackData(ideEntityService.saveOrUpdate(bo));
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg(e.getMessage());
		}
		return back;
	}
	
	@ResponseBody
	@RequestMapping(value = "delete" )
	public JsonBackData deleteById(@RequestParam String id) {
		JsonBackData back = new JsonBackData();
		try {
			ideEntityService.delete(id);
		} catch (BusinessException e) {
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败，" + e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			back.setSuccess(false);
			back.setBackMsg("查询列表数据失败！");
		}
		return back;
	}

}
