package com.ejianc.foundation.front.business.ide.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironment;
import com.ejianc.foundation.front.business.ide.service.IdeAccountService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.front.business.ide.service.IdeReleaseService;
import com.ejianc.foundation.front.util.JsonBackData;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping(value = "ide/release")
public class IdeReleaseController {
    private static final Logger log = LoggerFactory.getLogger(IdeReleaseController.class);

    @Autowired
    private IdeReleaseService releaseService;
    @Autowired
    private IdeEnvironmentService ideEnvironmentService;
    @Autowired
    private IdeAccountService accountService;

    @SuppressWarnings("unchecked")
	@ResponseBody
    @RequestMapping(value = "release" ,method = RequestMethod.POST)
    public JsonBackData release(@RequestBody Map<String, Object> params) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        String version = (String) params.get("version");
        Map<String, Object> appList = (Map<String, Object>) params.get("appList");
        try {
        	releaseService.releaseAppIds(appList, version);
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("发版失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "findReleases" ,method = RequestMethod.GET)
    public JsonBackData findReleases(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.findReleases(appId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("获取版本列表失败：" + e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value = "findReleasePages" ,method = RequestMethod.GET)
    public JsonBackData findReleasePages(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.findReleasePages(releaseGroupId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("获取发版页面列表失败：" + e.getMessage());
        }
        return back;
    }

    /**
    * pc设计器发布
    * */
    @ResponseBody
    @RequestMapping(value = "online" ,method = RequestMethod.GET)
    public JsonBackData online(HttpServletRequest request, String releaseGroupId, String envUrl) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            IdeAccountBo currUser = accountService.getCurrUser(request);
            if(currUser == null){
                back.setSuccess(false);
                back.setBackMsg("上线失败：当前账号已登录失效请重新登录后再发布！");
                return back;
            }
            IdeEnvironment environment = ideEnvironmentService.findByUrl(envUrl);
            if(environment == null){
                back.setSuccess(false);
                back.setBackMsg("上线失败：目标环境"+envUrl+"未注册！");
                return back;
            }
            if(StringUtils.isNotEmpty(environment.getPublishUser())){
                if(!environment.getPublishUser().contains(currUser.getCode())){
                    back.setSuccess(false);
                    back.setBackMsg("上线失败：你没有目标环境"+envUrl+"上线权限！");
                    return back;
                }
            }
            releaseService.online(releaseGroupId, envUrl);
        } catch (Exception e) {
            log.error("上线失败！", e);
            back.setSuccess(false);
            back.setBackMsg("上线失败：" + e.getMessage());
        }
        return back;
    }

    /**
     * 导出文本到txt文件并通过浏览器下载
     */
    @ResponseBody
    @RequestMapping(value = "exportTextToTxt", method = RequestMethod.GET)
    public void exportTextToTxt(@RequestParam String releaseGroupId, HttpServletResponse response) throws IOException {
        JSONObject onlineText = releaseService.getOnlineText(releaseGroupId);
        String textContent = onlineText.getString("textContent");
        byte[] contentBytes = textContent.getBytes(StandardCharsets.UTF_8);
        String fileName = onlineText.getString("version");
        // 编码文件名
        try {
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        } catch (IOException e) {
            log.error("Error encoding file name", e);
            fileName = "default.txt";
        }

        // 设置响应头
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setContentLength(contentBytes.length);

        // 写入文件内容到响应输出流
        try (OutputStream outputStream = response.getOutputStream()) {
            outputStream.write(contentBytes);
            outputStream.flush();
        } catch (IOException e) {
            log.error("Error writing to output stream", e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "viewOnlineHistory" ,method = RequestMethod.GET)
    public JsonBackData viewOnlineHistory(String appId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            back.setBackData(releaseService.viewOnlineHistory(appId));
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("查看上线历史记录失败" + e.getMessage());
        }
        return back;
    }
    
    @ResponseBody
    @RequestMapping(value = "deleteVersion" ,method = RequestMethod.GET)
    public JsonBackData deleteVersion(String releaseGroupId) {
        JsonBackData back = new JsonBackData();
        back.setSuccess(true);
        try {
            releaseService.deleteVersion(releaseGroupId);
        } catch (Exception e) {
            back.setSuccess(false);
            back.setBackMsg("查看上线历史记录失败" + e.getMessage());
        }
        return back;
    }
}
