package com.ejianc.foundation.front.business.ide.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.front.business.ide.bo.IdeProductAppBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.framework.core.exception.BusinessException;


/**
 * 提供给开发者开放平台使用
 * @author Dio.zhu
 */
public interface IdeAppOpenService {
    /** 在指定的产品项目下面新增|更新应用 */	
    void saveAppForProduct(IdeApp ideApp) throws BusinessException, Exception;
    
	/**查找指定产品项目下的全部应用**/
    IdeProductAppBo findAppByProduct(String productId) throws BusinessException;
    
    /** 在指定的产品项目下面新增|更新应用分组 */	
    IdeAppGroup saveAppGroupForProduct(IdeAppGroup appGroup) throws BusinessException, Exception;
    
	/**查找指定应用下的全部页面**/
    List<IdeModule> findPageByProductApp(String appId) throws BusinessException;
     
    /**统计每个产品下面的应用个数**/
    Map<String,Integer> findProductAppCount(List<String> productIds);
}
