package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentBO;
import com.ejianc.foundation.front.business.ide.entity.IdeEnvironment;
import com.ejianc.framework.core.exception.BusinessException;

public interface IdeEnvironmentService {
	
	Page<IdeEnvironmentBO> findAll(Pageable pageable) throws BusinessException,Exception;
	
	void saveOrUpdate(IdeEnvironmentBO bo) throws BusinessException,Exception;
	
	void deleteByUrls(String[] urls)throws BusinessException,Exception;
	
	IdeEnvironmentBO findByUrl(String url,int proType) throws BusinessException,Exception;

	IdeEnvironment findByUrl(String url);

	//根据环境地址和团队判断是否存在白名单中
	boolean isInWhiteList(String url,String teamId);
	 
	//查找全部的注册环境
	List<IdeEnvironment> findAllUrls();

	IdeEnvironment findById(String id);


}
