package com.ejianc.foundation.front.business.ide.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleDataBO;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;

/**
 * Created by cdr_c on 2017/6/15.
 */
public interface IdeModuleDataService {

    /**
     * 解析ideModule数据
     *
     * @param moduleId moduleId
     * @return ideModuleData
     */
    IdeModuleData createFromIdeModule(String moduleId);

    /**
     * 解析ideModule数据 
     *
     * @param moduleIds moduleIds
     * @return ideModuleData map
     */
    Map<Long, IdeModuleData> createFromIdeModules(List<String> moduleIds);

    /**
     * 解析ideModule数据
     *
     * @param module ideModule
     * @return ideModuleData
     */
    IdeModuleData createFromIdeModule(IdeModule module);

    /**
     * 解析ideApp数据
     *
     * @param appId appId
     * @return ideModuleData list
     */
    List<IdeModuleData> createFromIdeApp(String appId);

    List<IdeModuleData> createFromUser(String userId);

    /**
     * 根据moduleIds和uitypes查找ideModuleData
     *
     * @param moduleIds moduleIds
     * @param uiTypes   uitypes
     * @return ideModuleData map，key: moduleId, value: ideModuleData
     */
    Map<String, List<IdeModuleData>> findByModuleIdsAndUitypes(List<String> moduleIds, List<String> uiTypes);
    
    /**
     * 根据指定实体查找IdeModuleDataBO
     * @param entityName entityName
     * @return IdeModuleDataBO list
     */
    List<IdeModuleDataBO> findDataByEntity(String entityName);
    
}
